# Twitch Video Ops Specific Party Account Changes

This repository is meant to maintain Video CoreServices specific changes in the twitch-video-ops-aws party account.

This is to isolate the necessary changes from [`tf-infra`](https://git.xarth.tv/vidops/tf-infra) repository.

If necessary, make the appropriate changes in the future for the staging account.

## Usage

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Requirements](#requirements)
- [Deployment](#deployment)
- [Development](#development)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Requirements

1. AWS credentials to assume `Admin` role of [twitch-bs-video-ops-aws@amazon.com (277437172290)](https://isengard.amazon.com/console-access) account.

## Deployment

Standard terraform arguments. E.g. `plan|apply|...`. E.g.

1. `./deploy.sh plan`
1. `./deploy.sh apply`

## Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)
  * [`shellcheck`](https://github.com/koalaman/shellcheck#user-content-installing)

Run `pre-commit install` to install `pre-commit` hook.
