#!/usr/bin/env bash

set -eo pipefail

usage() {
    cat <<EOF
Usage: $0 <command> [args ...]

  <command> [args ...]
    In general, these are command and args that are passed to terraform binary as
    arguments

    E.g.
      $0 plan

      gets passed to terraform as

      terraform plan
EOF
    exit 1
}

requirements() {
    command -v tfenv &> /dev/null || ( echo "tfenv required but missing" && usage )
}

tf_init() {
    shift
    terraform init "$@" -reconfigure
}

# Print usage if no arguments or -h is given
[[ "$#" -lt 1 || "$1" == "-h" ]] && usage

requirements

case "$1" in
    init)
        tf_init "$@"
        ;;
    plan|apply)
        tf_init "$@"
        exec terraform "$@"
        ;;
    *)
        exec terraform "$@"
        ;;
esac
