
module "video_org_principal_destination" {
  source = "git::git+ssh://git@git.xarth.tv/terraform-modules/video-organization-principal.git//destination?ref=0a6c847"
}

data "aws_iam_policy_document" "cloudwatch_trust_policy" {
  source_json = module.video_org_principal_destination.policy.json

  statement {
    sid = "DefaultPerms"
    principals {
      type = "AWS"
      identifiers = [
        "arn:aws:iam::152548578290:role/video-puppet-ca-stage",
        "arn:aws:iam::152548578290:role/video-puppet-master-stage",
        "arn:aws:iam::277437172290:role/video-puppet-ca-prod",
        "arn:aws:iam::277437172290:role/video-puppet-master-prod",
        "arn:aws:iam::230552635125:role/MachineRole",
        "arn:aws:iam::277437172290:role/SSMServiceRole",
        "arn:aws:iam::277437172290:role/consul-master-us-east-1",
        "arn:aws:iam::277437172290:role/consul-master-us-west-2",
        "arn:aws:iam::085651689207:role/consul-master-eu-west-2",
        "arn:aws:iam::043714768218:role/jenkins-prod-slave"
      ]
    }
    actions = ["sts:AssumeRole"]
  }
}

resource "aws_iam_role" "cw_agent_logs" {
  name               = "CloudwatchAgentLogs"
  assume_role_policy = data.aws_iam_policy_document.cloudwatch_trust_policy.json
}

# use canned policy for now.
# later we can limit scope between metrics and logs roles.
resource "aws_iam_role_policy_attachment" "cw_agent_logs" {
  role       = aws_iam_role.cw_agent_logs.id
  policy_arn = "arn:aws:iam::aws:policy/CloudWatchAgentServerPolicy"
}

output "logs_arn" {
  value = aws_iam_role.cw_agent_logs.arn
}

resource "aws_iam_role" "cw_agent_metrics" {
  name               = "CloudwatchAgentMetrics"
  assume_role_policy = data.aws_iam_policy_document.cloudwatch_trust_policy.json
}

resource "aws_iam_policy" "amazon_sdk_metrics" {
  name = "AmazonSDKMetrics"

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "sdkmetrics:*"
            ],
            "Resource": "*"
        }
    ]
}
EOF
}

# use canned policy for now.
# later we can limit scope between metrics and logs roles.
resource "aws_iam_role_policy_attachment" "cw_agent_metrics" {
  role       = aws_iam_role.cw_agent_metrics.id
  policy_arn = "arn:aws:iam::aws:policy/CloudWatchAgentServerPolicy"
}

resource "aws_iam_role_policy_attachment" "amazon_sdk_metrics" {
  role       = "${aws_iam_role.cw_agent_metrics.id}"
  policy_arn = "${aws_iam_policy.amazon_sdk_metrics.arn}"
}

output "metrics_arn" {
  value = aws_iam_role.cw_agent_metrics.arn
}
