terraform {
  required_version = "=0.12.21"

  backend "s3" {
    region         = "us-west-2"
    dynamodb_table = "terraform_locks"
    bucket         = "twitch-video-ops-aws-tf-state"
    key            = "tf-io-video-ops-party-account/terraform.tfstate"
  }
}

# Stub us-west-2 since it's a required parameter
provider "aws" {
  region  = "us-west-2"
  version = "~> 2.49"
}

provider "null" {
  version = "~> 2.1"
}

# Only allow Admin to execute TF changes
data "aws_caller_identity" "current" {}

resource "null_resource" "validate_role" {
  count = element(split("/", data.aws_caller_identity.current.arn), 1) == "Admin" ? 0 : "Please use Admin role to perform operations"
}
