#########################
# Milliner mapping roles
#########################

module "milliner_principal" {
  source = "git::ssh://git@git.xarth.tv/terraform-modules/milliner-principal-policy.git?ref=cb7de8a"
}

resource "aws_iam_role" "consul-master" {
  name               = "consul-master"
  assume_role_policy = module.milliner_principal.policy_document
}

module "org_principal_consul_master" {
  source        = "git::git+ssh://git@git.xarth.tv/terraform-modules/video-organization-principal.git//source?ref=0a6c847"
  iam_role_name = aws_iam_role.consul-master.name
}

resource "aws_iam_role" "pop-master" {
  name               = "pop-master"
  assume_role_policy = module.milliner_principal.policy_document
}

module "org_principal_pop_master" {
  source        = "git::git+ssh://git@git.xarth.tv/terraform-modules/video-organization-principal.git//source?ref=0a6c847"
  iam_role_name = aws_iam_role.pop-master.name
}

resource "aws_iam_role" "pop-master-development" {
  name               = "pop-master-development"
  assume_role_policy = module.milliner_principal.policy_document
}

module "org_principal_pop_master_dev" {
  source        = "git::git+ssh://git@git.xarth.tv/terraform-modules/video-organization-principal.git//source?ref=0a6c847"
  iam_role_name = aws_iam_role.pop-master-development.name
}

resource "aws_iam_role" "squid-proxy" {
  name               = "squid-proxy"
  assume_role_policy = module.milliner_principal.policy_document
}

module "org_principal_squid_proxy" {
  source        = "git::git+ssh://git@git.xarth.tv/terraform-modules/video-organization-principal.git//source?ref=0a6c847"
  iam_role_name = aws_iam_role.squid-proxy.name
}

resource "aws_iam_role" "squid-proxy-development" {
  name               = "squid-proxy-development"
  assume_role_policy = module.milliner_principal.policy_document
}

module "org_principal_squid_proxy_dev" {
  source        = "git::git+ssh://git@git.xarth.tv/terraform-modules/video-organization-principal.git//source?ref=0a6c847"
  iam_role_name = aws_iam_role.squid-proxy-development.name
}

resource "aws_iam_role" "consul-wanmaster" {
  name               = "consul-wanmaster"
  assume_role_policy = module.milliner_principal.policy_document
}

module "org_principal_consul_wanmaster" {
  source        = "git::git+ssh://git@git.xarth.tv/terraform-modules/video-organization-principal.git//source?ref=0a6c847"
  iam_role_name = aws_iam_role.consul-wanmaster.name
}

resource "aws_iam_role" "ntp" {
  name               = "ntp"
  assume_role_policy = module.milliner_principal.policy_document
}

module "org_principal_ntp" {
  source        = "git::git+ssh://git@git.xarth.tv/terraform-modules/video-organization-principal.git//source?ref=0a6c847"
  iam_role_name = aws_iam_role.ntp.name
}
