# Video CoreServices Voncount Deployment

This deploys the voncount cluster that the Edge team has built to support sending metrics to a managed graphite backend. Note that most of the subcomponents has been forked into `video-coreservices` org. This particular deployment supports a MetricFire backend.

Container repos:

* [vouncount](https://git.xarth.tv/video-coreservices/voncount)
* [go-statsd-proxy](https://git.xarth.tv/video-coreservices/go-statsd-proxy)

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
**Table of Contents**

- [Components](#components)
- [Requirements](#requirements)
- [Self Hosted Graphite](#self-hosted-graphite)
- [Deployment](#deployment)
  - [Usage](#usage)
  - [Example](#example)
  - [Deploying new containers](#deploying-new-containers)
- [Terraform inputs](#terraform-inputs)
  - [Requirements](#requirements-1)
  - [Providers](#providers)
  - [Modules](#modules)
  - [Resources](#resources)
  - [Inputs](#inputs)
  - [Outputs](#outputs)
- [Development](#development)
  - [Known Issues](#known-issues)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Components

Voncount is a tiered solution for scalability and has two main components:

 1. [**go-statsd-proxy**](https://git.xarth.tv/video-coreservices/go-statsd-proxy) takes udp metrics requests in the statsd format and distributes them across a consistent hashing pool of statsd instances

 1. [**statsite**](https://git.xarth.tv/video-coreservices/voncount/blob/master/docs/statsite.md) is a high-throughput statsd replacement that aggregates sharded statistics.

    * [**Plumbago**](https://git.xarth.tv/edge/plumbago) is a replacement emitter for graphite stats with better throughput and observability.

![Architecture Diagram](docs/architecture.svg)

## Requirements

* [tfenv](https://github.com/tfutils/tfenv#automatic)
* AWS credentials to assume `Admin` roles of
  * Staging - [twitch-bs-video-ops-stg@amazon.com (152548578290)](https://isengard.amazon.com/console-access) account.
  * Prod - [twitch-video-coreservices+metrics-prod-us-west-2@amazon.com (355334781110)](https://isengard.amazon.com/console-access) account.

## Self Hosted Graphite

The latest iteration assumes sending metrics directly to a self hosted graphite cluster. Metricfire and Grafana Cloud are now not supported.

## Deployment

The `deploy.sh` script takes an argument for `env` and `region`. `env` can be one of `dev|staging` and `region` will always be `us-west-2` as this is only deployed in the `us-west-2` region.

Environment specific variables is found under `conf/<env>/<region>/variables.tfvars`. E.g. `[conf/prod/us-west-2/variables.tfvars](./conf/prod/us-west-2/variables.tfvars)` is for `us-west-2` `prod`.

### Usage

```bash
./deploy.sh -e <env> -r <region> apply
```

### Example

A warning with regards `Interpolation-only expressions are deprecated` is intentional as of now.

```terraform
./deploy.sh -e staging -r us-west-2 plan

Initializing modules...

Initializing the backend...

Successfully configured the backend "s3"! Terraform will automatically
use this backend unless the backend configuration changes.

Initializing provider plugins...

Terraform has been successfully initialized!

You may now begin working with Terraform. Try running "terraform plan" to see
any changes that are required for your infrastructure. All Terraform commands
should now work.

If you ever set or change modules or backend configuration for Terraform,
rerun this command to reinitialize your working directory. If you forget, other
commands will detect it and remind you to do so if necessary.
Refreshing Terraform state in-memory prior to plan...
The refreshed state will be used to calculate this plan, but will not be
persisted to local or remote state storage.

module.statsite.module.ecs.aws_iam_role.ecs_task_execution_role: Refreshing state... [id=ecs_task_execution_statsite_statsd-pipeline]
module.statsite.module.ecs.module.ecs_asg.data.aws_ami.ecs_ami: Refreshing state...
module.statsd_proxy.data.aws_iam_policy_document.execution: Refreshing state...
module.statsd_proxy.aws_lb.proxy: Refreshing state... [id=arn:aws:elasticloadbalancing:us-west-2:152548578290:loadbalancer/net/statsd-proxy/0aa4ecd1f5d05382]
module.statsite.aws_cloudwatch_metric_alarm.metrics_written[0]: Refreshing state... [id=statsite_metrics_written]
module.statsite.module.ecs.data.aws_caller_identity.current: Refreshing state...
module.statsite.module.ecs.data.aws_iam_account_alias.current: Refreshing state...
module.statsd_proxy.data.aws_iam_policy_document.put_cloudwatch_metrics: Refreshing state...
module.statsd_proxy.data.aws_region.current: Refreshing state...
module.statsite.module.ecs.module.ecs_asg.data.aws_region.current: Refreshing state...
module.statsd_proxy.data.aws_ssm_parameter.ecs_optimized_ami_id: Refreshing state...
module.statsite.module.ecs.aws_ecs_cluster.main: Refreshing state... [id=arn:aws:ecs:us-west-2:152548578290:cluster/statsite]
module.jenkins.data.aws_iam_policy_document.allow_jenkins_account: Refreshing state...
aws_cloudwatch_log_group.statsite: Refreshing state... [id=statsite_logs]
aws_iam_role.ecs_task_role: Refreshing state... [id=ecs_task_role_statsd-pipeline]
module.statsite.module.ecs.aws_cloudwatch_log_group.ecs_init_logs: Refreshing state... [id=statsite-ecs-init-logs]
module.statsd_proxy.aws_ecr_repository.proxy: Refreshing state... [id=statsd-proxy]
module.statsd_proxy.aws_lb_target_group.proxy: Refreshing state... [id=arn:aws:elasticloadbalancing:us-west-2:152548578290:targetgroup/statsd-proxy/4ab472a3b985d8cd]
module.core_account.data.aws_iam_policy_document.ecs_service: Refreshing state...
module.core_account.data.aws_caller_identity.current: Refreshing state...
module.core_account.data.aws_iam_policy_document.ecs_host: Refreshing state...
data.aws_caller_identity.current: Refreshing state...
module.statsd_proxy.data.aws_iam_policy_document.container_instance: Refreshing state...
module.core_account.data.aws_iam_policy_document.xray_task: Refreshing state...
module.statsite.module.ecs.aws_cloudwatch_log_group.ecs_agent_logs: Refreshing state... [id=statsite-ecs-agent-logs]
module.statsd_proxy.aws_cloudwatch_log_group.proxy: Refreshing state... [id=statsd-proxy]
aws_ecr_repository.statsite: Refreshing state... [id=statsite]
module.core_account.aws_iam_user.deployment: Refreshing state... [id=vidcs-statsd-pipeline-deploy]
module.statsite.module.ecs.aws_cloudwatch_log_group.ssm_logs: Refreshing state... [id=statsite-ssm-ec2-logs]
module.statsd_proxy.data.aws_iam_policy_document.service: Refreshing state...
module.statsd_proxy.data.aws_iam_policy_document.task: Refreshing state...
module.core_account.data.aws_iam_policy_document.ecs_autoscale: Refreshing state...
module.statsd_proxy.aws_iam_role.execution: Refreshing state... [id=execution_statsd-proxy20200925200948748400000003]
module.jenkins.aws_iam_role.jenkins_iam_role: Refreshing state... [id=jenkins-to-ecr-metrics-role]
module.core_account.aws_iam_role.ecs_service: Refreshing state... [id=vidcs-statsd-pipeline-ecs-service]
module.core_account.aws_iam_role.ecs_host: Refreshing state... [id=vidcs-statsd-pipeline-ecs-host]
module.core_account.data.aws_iam_policy_document.pipeline_ssm_permissions: Refreshing state...
module.statsite.module.ecs.aws_iam_role_policy_attachment.ecs_task_execution_role: Refreshing state... [id=ecs_task_execution_statsite_statsd-pipeline-20200925200952123500000005]
module.statsd_proxy.aws_iam_role.container_instance: Refreshing state... [id=instance_statsd-proxy20200925200945571500000001]
aws_iam_role_policy.cloudwatch_metrics_policy: Refreshing state... [id=ecs_task_role_statsd-pipeline:statsd-pipeline_cloudwatch_metrics_policy]
module.core_account.aws_iam_role.xray_task: Refreshing state... [id=vidcs-statsd-pipeline-xray]
module.statsd_proxy.aws_ecr_lifecycle_policy.proxy: Refreshing state... [id=statsd-proxy]
module.statsd_proxy.aws_iam_role.service: Refreshing state... [id=service_statsd-proxy20200925200945575500000002]
module.statsd_proxy.aws_iam_role.task: Refreshing state... [id=task_statsd-proxy20200925200950693300000004]
module.statsd_proxy.aws_lb_listener.proxy: Refreshing state... [id=arn:aws:elasticloadbalancing:us-west-2:152548578290:listener/net/statsd-proxy/0aa4ecd1f5d05382/11248a55cd386c73]
module.core_account.aws_iam_role.ecs_autoscale: Refreshing state... [id=vidcs-statsd-pipeline-ecs-task-autoscale]
module.core_account.aws_iam_policy.pipeline_ssm_permissions: Refreshing state... [id=arn:aws:iam::152548578290:policy/vidcs-statsd-pipeline-ssm-values]
aws_ecr_lifecycle_policy.statsite_lifecycle_policy: Refreshing state... [id=statsite]
module.core_account.data.aws_iam_policy_document.build_deployment: Refreshing state...
module.statsd_proxy.aws_iam_role_policy_attachment.execution: Refreshing state... [id=execution_statsd-proxy20200925200948748400000003-2020092520095495880000000d]
module.statsd_proxy.aws_iam_role_policy_attachment.container_instance_ecs: Refreshing state... [id=instance_statsd-proxy20200925200945571500000001-20200925200953252400000008]
module.statsd_proxy.aws_iam_role_policy_attachment.container_instance_ssm: Refreshing state... [id=instance_statsd-proxy20200925200945571500000001-20200925200953439300000009]
module.statsd_proxy.aws_iam_instance_profile.container_instance: Refreshing state... [id=instance_statsd-proxy20200925200952590300000007]
module.core_account.aws_iam_role_policy_attachment.ecs_host_ssm_policy: Refreshing state... [id=vidcs-statsd-pipeline-ecs-host-2020092520095458380000000c]
module.core_account.aws_iam_role_policy_attachment.ecs_host_attach_policy: Refreshing state... [id=vidcs-statsd-pipeline-ecs-host-2020092520095430420000000b]
module.core_account.aws_iam_instance_profile.ecs_host: Refreshing state... [id=vidcs-statsd-pipeline-ecs-host]
module.core_account.aws_iam_instance_profile.ecs_service: Refreshing state... [id=vidcs-statsd-pipeline-ecs-service]
module.core_account.aws_iam_role_policy_attachment.ecs_service_attach_policy: Refreshing state... [id=vidcs-statsd-pipeline-ecs-service-20200925200957980800000018]
module.core_account.aws_iam_role.build_deployment: Refreshing state... [id=vidcs-statsd-pipeline-build-deployment]
aws_iam_role_policy_attachment.jenkins_role_ecr_poweruser: Refreshing state... [id=jenkins-to-ecr-metrics-role-20200925200955956500000011]
module.statsd_proxy.aws_iam_role_policy.put_cloudwatch_metrics: Refreshing state... [id=task_statsd-proxy20200925200950693300000004:put_cloudwatch_metrics]
module.core_account.aws_iam_role_policy.policy: Refreshing state... [id=vidcs-statsd-pipeline-xray:vidcs-statsd-pipeline-xray-assume-role]
module.statsd_proxy.data.aws_iam_policy_document.fetch_host_config: Refreshing state...
module.statsd_proxy.aws_iam_role_policy_attachment.service: Refreshing state... [id=service_statsd-proxy20200925200945575500000002-20200925200952421900000006]
module.core_account.aws_iam_instance_profile.ecs_autoscale: Refreshing state... [id=vidcs-statsd-pipeline-ecs-autoscale]
module.core_account.aws_iam_role_policy_attachment.ecs_autoscale_attach_policy: Refreshing state... [id=vidcs-statsd-pipeline-ecs-task-autoscale-2020092520095384520000000a]
module.statsite.module.ecs.aws_ecs_task_definition.app: Refreshing state... [id=statsite]
module.statsd_proxy.aws_launch_template.proxy: Refreshing state... [id=lt-0a6aa2cbf1d1fc170]
module.statsd_proxy.aws_iam_role_policy.fetch_host_config: Refreshing state... [id=task_statsd-proxy20200925200950693300000004:fetch_host_config]
module.core_account.data.aws_iam_policy_document.allow_build_user_assume_build_role: Refreshing state...
module.core_account.aws_iam_role_policy_attachment.build_deployment_attach_policy_ssm_permissions: Refreshing state... [id=vidcs-statsd-pipeline-build-deployment-2020092520100040570000001b]
module.core_account.aws_iam_role_policy_attachment.build_deployment_attach_policyEC2: Refreshing state... [id=vidcs-statsd-pipeline-build-deployment-2020092520100135890000001c]
module.core_account.aws_iam_role_policy_attachment.build_deployment_attach_policyS3: Refreshing state... [id=vidcs-statsd-pipeline-build-deployment-20200925201000383200000019]
module.core_account.aws_iam_role_policy_attachment.build_deployment_attach_policyCWlogs: Refreshing state... [id=vidcs-statsd-pipeline-build-deployment-2020092520100038910000001a]
module.core_account.aws_iam_user_policy.allow_user_assume_role: Refreshing state... [id=vidcs-statsd-pipeline-deploy:vidcs-statsd-pipeline-deploy-user-assume-role]
module.statsite.module.ecs.aws_ecs_service.main: Refreshing state... [id=arn:aws:ecs:us-west-2:152548578290:service/statsite/statsite]
module.statsite.module.ecs.aws_iam_role_policy_attachment.allow_send_access_logs_policy: Refreshing state... [id=vidcs-statsd-pipeline-ecs-host-20200925200956923000000012]
module.statsite.module.ecs.module.ecs_asg.aws_launch_configuration.app_conf: Refreshing state... [id=edge-platform-statsd-pipeline-statsite20200925221407865900000001]
module.statsd_proxy.aws_autoscaling_group.proxy: Refreshing state... [id=statsd-proxy20200925200956927800000013]
module.statsd_proxy.aws_ecs_task_definition.proxy: Refreshing state... [id=statsd-proxy]
module.statsd_proxy.aws_ecs_capacity_provider.proxy: Refreshing state... [id=arn:aws:ecs:us-west-2:152548578290:capacity-provider/provider_statsd-proxy]
module.statsite.module.ecs.module.ecs_asg.aws_autoscaling_group.app_asg: Refreshing state... [id=edge-platform-statsd-pipeline-statsite]
module.statsd_proxy.aws_ecs_cluster.proxy: Refreshing state... [id=arn:aws:ecs:us-west-2:152548578290:cluster/statsd-proxy]
module.statsite.module.ecs.module.ecs_asg.aws_autoscaling_policy.app_asg_scalein_policy: Refreshing state... [id=edge-platform-statsd-pipeline-statsite-scalein-policy]
module.statsite.module.ecs.module.ecs_asg.aws_autoscaling_policy.app_asg_scaleout_policy: Refreshing state... [id=edge-platform-statsd-pipeline-statsite-scaleout-policy]
module.statsd_proxy.aws_ecs_service.proxy: Refreshing state... [id=arn:aws:ecs:us-west-2:152548578290:service/statsd-proxy/statsd-proxy]
module.statsite.module.ecs.module.ecs_asg.aws_cloudwatch_metric_alarm.asg_low_cpu: Refreshing state... [id=edge-platform-statsd-pipeline-statsite-low-cpu]
module.statsite.module.ecs.module.ecs_asg.aws_cloudwatch_metric_alarm.asg_high_cpu: Refreshing state... [id=edge-platform-statsd-pipeline-statsite-high-cpu]

------------------------------------------------------------------------

No changes. Infrastructure is up-to-date.

This means that Terraform did not detect any differences between your
configuration and real physical resources that exist. As a result, no
actions need to be performed.
```

### Deploying new containers

The [vouncount](https://git.xarth.tv/video-coreservices/voncount) and [go-statsd-proxy](https://git.xarth.tv/video-coreservices/go-statsd-proxy) have associated jenkins jobs which will upload new images to the corresponding `staging` and `prod` ECR accounts. `prod` account will only receive image builds on merge to `master` changes.

To update which image tags to be utilized by ECS, update the corresponding `statsd_proxy_image_tag`, and/or `statsite_image_tag` and rerun the `./deploy.sh` steps above.

**TODO** More info on deployment, metrics, etc

## Terraform inputs

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
### Requirements

| Name | Version |
|------|---------|
| <a name="requirement_terraform"></a> [terraform](#requirement\_terraform) | =0.14.7 |
| <a name="requirement_aws"></a> [aws](#requirement\_aws) | ~> 3.7.0 |
| <a name="requirement_template"></a> [template](#requirement\_template) | ~> 2.1 |

### Providers

| Name | Version |
|------|---------|
| <a name="provider_aws"></a> [aws](#provider\_aws) | ~> 3.7.0 |

### Modules

| Name | Source | Version |
|------|--------|---------|
| <a name="module_core_account"></a> [core\_account](#module\_core\_account) | git::git+ssh://git@git.xarth.tv/video-coreservices/tf-mod-voncount-core-account?ref=v1.0.0 |  |
| <a name="module_jenkins"></a> [jenkins](#module\_jenkins) | git@git.xarth.tv:video-coreservices/tf-mod-jenkins-role.git?ref=v1.0.1 |  |
| <a name="module_statsd_proxy"></a> [statsd\_proxy](#module\_statsd\_proxy) | git@git.xarth.tv:video-coreservices/go-statsd-proxy.git//terraform?ref=v0.5.3 |  |
| <a name="module_statsite"></a> [statsite](#module\_statsite) | ./modules/statsite |  |

### Resources

| Name | Type |
|------|------|
| [aws_cloudwatch_log_group.statsite](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/cloudwatch_log_group) | resource |
| [aws_ecr_lifecycle_policy.statsite_lifecycle_policy](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/ecr_lifecycle_policy) | resource |
| [aws_ecr_repository.statsite](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/ecr_repository) | resource |
| [aws_iam_role.ecs_task_role](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_role) | resource |
| [aws_iam_role_policy.cloudwatch_metrics_policy](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_role_policy) | resource |
| [aws_iam_role_policy_attachment.jenkins_role_ecr_poweruser](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_role_policy_attachment) | resource |
| [aws_caller_identity.current](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/caller_identity) | data source |

### Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_env"></a> [env](#input\_env) | The stack environment. One of dev, staging, or prod | `string` | n/a | yes |
| <a name="input_graphite_url"></a> [graphite\_url](#input\_graphite\_url) | The URL for the graphite endpoint. | `string` | n/a | yes |
| <a name="input_owner"></a> [owner](#input\_owner) | The email address of the owner of this account | `string` | n/a | yes |
| <a name="input_pagerduty_sns_topic_arns"></a> [pagerduty\_sns\_topic\_arns](#input\_pagerduty\_sns\_topic\_arns) | An list of SNS topic ARNs that has a pagerduty integration subscribed to it. | `list(string)` | n/a | yes |
| <a name="input_region"></a> [region](#input\_region) | The AWS region to deploy this stack to | `string` | n/a | yes |
| <a name="input_security_groups"></a> [security\_groups](#input\_security\_groups) | The security groups to associate this stack to | `list(string)` | n/a | yes |
| <a name="input_statsd_proxy_asg_instances"></a> [statsd\_proxy\_asg\_instances](#input\_statsd\_proxy\_asg\_instances) | The desired cluster size for statsd-proxy | `number` | `9` | no |
| <a name="input_statsd_proxy_image_tag"></a> [statsd\_proxy\_image\_tag](#input\_statsd\_proxy\_image\_tag) | The image hash/tag that will be used to run statsd-proxy | `string` | n/a | yes |
| <a name="input_statsite_cluster_size"></a> [statsite\_cluster\_size](#input\_statsite\_cluster\_size) | The desired cluster size for statsite | `number` | `12` | no |
| <a name="input_statsite_image_tag"></a> [statsite\_image\_tag](#input\_statsite\_image\_tag) | The image hash/tag that will be used to run statsite | `string` | n/a | yes |
| <a name="input_subnets"></a> [subnets](#input\_subnets) | The subnets to deploy this stack to | `list(string)` | n/a | yes |
| <a name="input_vpc_id"></a> [vpc\_id](#input\_vpc\_id) | The VPC to deploy this stack to | `string` | n/a | yes |

### Outputs

No outputs.
<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->

## Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)
  * [`shellcheck`](https://github.com/koalaman/shellcheck#user-content-installing)

Run `pre-commit install` to install `pre-commit` hook.

### Known Issues

You may encounter the following issues when `terraform validate` part of the `pre-commit` hook is executed:

* `terraform` AWS provider requires a region to be set when `terraform validate` is being performed. If a region not set related error is prompted, set `export AWS_REGION=us-west-2` in your current terminal session.
* When trying to validate modules under the `modules` folder, `terraform init` needs to be executed in each module folder for the `pre-commit` to successfully validate each individual modules.
