# ECR Repositories

locals {
  ecr_lifecycle_policy = <<EOF
  {
      "rules": [
          {
              "rulePriority": 1,
              "description": "Keep last 400 images, of any age, out of a max of 1000",
              "selection": {
                  "tagStatus": "any",
                  "countType": "imageCountMoreThan",
                  "countNumber": 400
              },
              "action": {
                  "type": "expire"
              }
          }
      ]
  }
EOF
}

resource "aws_ecr_repository" "statsite" {
  name = "statsite"
}

resource "aws_ecr_lifecycle_policy" "statsite_lifecycle_policy" {
  repository = aws_ecr_repository.statsite.name
  policy     = local.ecr_lifecycle_policy
}
