variable "environment" {
  description = "Which env run of the service (staging/production/etc)"
  type        = string
}

variable "name" {
  description = "Name of the clusters these ASG hosts should take."
  type        = string
}

variable "max_size" {
  description = "Most number of hosts to have in this ASG"
  type        = number
}

variable "desired_capacity" {
  description = "Default number of hosts to have in this ASG.  Should be >= min and <= max"
  type        = number
}

variable "team" {
  description = "The twitch team (feeds/events/etc) that wants this resource"
  type        = string
}

variable "owner" {
  description = "Owner's email (jlindamo@twitch.tv) that wants twitch to pay for this."
  type        = string
}

variable "root_volume_size" {
  description = "Size in GB of the root volume in the ASG"
  type        = number
  default     = 32
}

variable "cluster_name" {
  description = "Name of the ECS cluster hosts should belong to"
  type        = string
}

# EC2 Instance Image
variable "ami" {
  description = "An ECS enabled AMI that these ASG hosts should run with.  If empty, will use the most recent AMI"
  type        = string
  default     = ""
}

# EC2 Instance Type
variable "instance_type" {
  description = "AWS instance type of these hosts (c4.2xlarge, etc)"
  type        = string
}

variable "host_key_name" {
  description = "Can leave blank, but will be an SSH keypair name"
  type        = string
  default     = ""
}

variable "container_instance_profile_id" {
  description = "The permissions ID these hosts get. Should probably use the one created by core."
  type        = string
}

variable "security_groups" {
  description = "Comma-separated string of Twitch subnet security groups to add EC2 instances into."
  type        = string
}

variable "vpc_zone_identifier" {
  description = "Subnets that ASG adds hosts to.  Usually .account.private_subnets"
  type        = string
}

variable "ssm_agent_loggroup" {
  description = "CloudWatch log group to send SSM agent logs to."
  type        = string
}

variable "ecs_agent_loggroup" {
  description = "CloudWatch log group to send ECS agent logs to."
  type        = string
}

variable "ecs_init_loggroup" {
  description = "CloudWatch log group to send ECS init logs to."
  type        = string
}

variable "instance_attributes" {
  type        = map(string)
  description = "Custom attributes added to instances. Useful for placement_attributes."
  default     = {}
}

variable "task_cleanup_wait_duration" {
  description = "Time duration to wait from when an ECS task is stopped until the Docker container is removed."
  default     = "3h"
  type        = string
}

variable "task_shutdown_wait_duration" {
  description = "Time duration to wait from when an ECS task is given a SIGTERM to when it is forcefully killed."
  default     = "30s"
  type        = string
}
