# Route53 Service Delegation Management for warp.live-video.net

This code manages `warp.live-video.net` and the infrastructure that performs DDNS updates. Refer [wiki](https://wiki.xarth.tv/display/VID/DNS+Validator+and+DDNS+Updates) for an overview of the entire infrastructure setup.


# Usage

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Requirements](#requirements)
- [Deployment](#deployment)
- [Development](#development)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Requirements

* [tfenv](https://github.com/tfutils/tfenv#automatic)
* AWS credentials to assume `Admin` role of [twitch-video-coreservices+warp-dns@amazon.com (804916306882)](https://isengard.amazon.com/console-access) account.

## Deployment

Refer the following:

1. [Infrastructure](./src/infra) - manage this account and the primary warp.live-video.net hosted zone.
1. [Warp CRUD Updater](./src/crud_updater) - manages the lambda which updates the warp DNS records for individual machines.
1. [POP Route53 Zone delegation](https://git.xarth.tv/video-coreservices/tf-io-dns-pop-delegation) - manages `<pop>.warp.live-video.net` delegation.

## Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)
  * [`shellcheck`](https://github.com/koalaman/shellcheck#user-content-installing)

Run `pre-commit install` to install `pre-commit` hook.
