# Warp CRUD Updater submodule

Creates the lambda/sqs stack for the CRUD updater as well as the blue green codedeploy pipeline. 

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Requirements](#requirements)
- [Deployment](#deployment)
- [Terraform Info](#terraform-info)
  - [Requirements](#requirements-1)
  - [Providers](#providers)
  - [Modules](#modules)
  - [Inputs](#inputs)
  - [Outputs](#outputs)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

# Requirements

1. AWS credentials to assume `Admin` role of one of the following accounts:
  - [twitch-warp-dns+edgeupdate-prod-us-east-2@amazon.com (618029135405)](https://isengard.amazon.com/console-access) account.
  - [twitch-warp-dns+edgeupdate-prod-us-west-2@amazon.com (733068333177)](https://isengard.amazon.com/console-access) account.
  - [twitch-warp-dns+edgeupdate-staging-us-west-2@amazon.com (410778197068)](https://isengard.amazon.com/console-access) account.


# Deployment

Deployment of new versions of this lambda as well as any infrastructure changes can be made by a simple tf apply.

Standard terraform arguments. E.g. `plan|apply|...`. E.g.

1. `./deploy.sh -e [prod|staging|dev] -r [<valid_aws_region>] plan`
1. `./deploy.sh -e [prod|staging|dev] -r [<valid_aws_region>] apply`

# Terraform Info

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
## Requirements

| Name | Version |
|------|---------|
| <a name="requirement_terraform"></a> [terraform](#requirement\_terraform) | =0.13.5 |
| <a name="requirement_archive"></a> [archive](#requirement\_archive) | ~> 2.2.0 |
| <a name="requirement_aws"></a> [aws](#requirement\_aws) | ~> 3.19 |
| <a name="requirement_local"></a> [local](#requirement\_local) | ~> 2.1.0 |
| <a name="requirement_random"></a> [random](#requirement\_random) | ~> 3.1.0 |

## Providers

No providers.

## Modules

| Name | Source | Version |
|------|--------|---------|
| <a name="module_cloudwatch_wiki"></a> [cloudwatch\_wiki](#module\_cloudwatch\_wiki) | git@git.xarth.tv:video-coreservices/tf-mod-cloudwatchdashboards-wiki.git?ref=v1.1.2 |  |
| <a name="module_lambda_deploy_stack"></a> [lambda\_deploy\_stack](#module\_lambda\_deploy\_stack) | git@git.xarth.tv:video-coreservices/tf-mod-lambda-pipeline.git?ref=v1.1.0 |  |
| <a name="module_slack_chatbot"></a> [slack\_chatbot](#module\_slack\_chatbot) | git@git.xarth.tv:video/chatbot-terraform.git//modules/chatbot?ref=v1.0.0 |  |
| <a name="module_slack_sns"></a> [slack\_sns](#module\_slack\_sns) | git@git.xarth.tv:video/chatbot-terraform.git//modules/sns?ref=v1.0.0 |  |
| <a name="module_sqs_lambda_stack"></a> [sqs\_lambda\_stack](#module\_sqs\_lambda\_stack) | git@git.xarth.tv:video-coreservices/tf-mod-dns-sqs-lambda.git?ref=v2.0.0 |  |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_dns_updater_role"></a> [dns\_updater\_role](#input\_dns\_updater\_role) | The ARN of the IAM role that allows the lambda to perform crud operations. | `string` | `"arn:aws:iam::804916306882:role/warp-dns-crud-lambda"` | no |
| <a name="input_env"></a> [env](#input\_env) | Service environment - (prod\|staging). | `string` | n/a | yes |
| <a name="input_input_sns_arn"></a> [input\_sns\_arn](#input\_input\_sns\_arn) | The ARN of the SNS topic to receive notifications to trigger the pipeline. | `any` | n/a | yes |
| <a name="input_pd_url"></a> [pd\_url](#input\_pd\_url) | The pagerduty URL alarms for the stack should send to. | `string` | `"https://events.pagerduty.com/integration/fb79deea275748acb67a80c0b88c7a7d/enqueue"` | no |
| <a name="input_pop_subdomain"></a> [pop\_subdomain](#input\_pop\_subdomain) | Whether to prepend the target\_dns\_domain with POP (i.e. <pop>.<target\_dns\_domain>, or only use target\_dns\_domain | `bool` | `true` | no |
| <a name="input_region"></a> [region](#input\_region) | The AWS region this service will be deployed. | `string` | n/a | yes |
| <a name="input_service_id"></a> [service\_id](#input\_service\_id) | The name of your application. | `string` | `"warp-dns-updater"` | no |
| <a name="input_target_dns_domain"></a> [target\_dns\_domain](#input\_target\_dns\_domain) | The name of the DNS subdomain to | `string` | `"warp.live-video.net"` | no |

## Outputs

No outputs.
<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
