variable "env" {
  description = "Service environment - (prod|staging)."
  type        = string
}

variable "region" {
  description = "The AWS region this service will be deployed."
  type        = string
}

variable "service_id" {
  description = "The name of your application."
  default     = "warp-dns-updater"
  type        = string
}

variable "target_dns_domain" {
  description = "The name of the DNS subdomain to "
  default     = "warp.live-video.net"
}

variable "input_sns_arn" {
  description = "The ARN of the SNS topic to receive notifications to trigger the pipeline."
}

variable "dns_updater_role" {
  description = "The ARN of the IAM role that allows the lambda to perform crud operations."
  default     = "arn:aws:iam::804916306882:role/warp-dns-crud-lambda"
}

variable "pd_url" {
  description = "The pagerduty URL alarms for the stack should send to."
  default     = "https://events.pagerduty.com/integration/fb79deea275748acb67a80c0b88c7a7d/enqueue"
}

variable "pop_subdomain" {
  description = "Whether to prepend the target_dns_domain with POP (i.e. <pop>.<target_dns_domain>, or only use target_dns_domain"
  type        = bool
  default     = true
}
