# Manage _Infra_ and Primary Warp hosted Zone

## Usage

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Requirements](#requirements)
- [Deployment](#deployment)
  - [Example Output](#example-output)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Requirements

1. AWS credentials to assume `Admin` role of [twitch-video-coreservices+warp-dns@amazon.com (804916306882)](https://isengard.amazon.com/console-access) account.
   ```bash
   # isengardcli
   isengardcli creds twitch-video-coreservices+warp-dns --role Admin
   ```

## Deployment

Standard terraform arguments. E.g. `plan|apply|...`. E.g.

1. `./deploy.sh plan`
1. `./deploy.sh apply`

### Example Output

```bash
./deploy.sh plan

Initializing modules...

Initializing the backend...

Successfully configured the backend "s3"! Terraform will automatically
use this backend unless the backend configuration changes.

Initializing provider plugins...
- Using previously-installed hashicorp/aws v3.19.0
- Using previously-installed hashicorp/null v2.1.2

Terraform has been successfully initialized!

You may now begin working with Terraform. Try running "terraform plan" to see
any changes that are required for your infrastructure. All Terraform commands
should now work.

If you ever set or change modules or backend configuration for Terraform,
rerun this command to reinitialize your working directory. If you forget, other
commands will detect it and remind you to do so if necessary.
Refreshing Terraform state in-memory prior to plan...
The refreshed state will be used to calculate this plan, but will not be
persisted to local or remote state storage.

module.primary.module.iam.data.aws_iam_policy.route53_read_only_access: Refreshing state... [id=arn:aws:iam::aws:policy/AmazonRoute53ReadOnlyAccess]
aws_iam_role_policy_attachment.mgmt_route53_full_access_attachment: Refreshing state... [id=tf-pop-dns-mgmt-20201202004506590000000002]
aws_iam_policy.tf_dynamodb_write: Refreshing state... [id=arn:aws:iam::804916306882:policy/tf-dynamodb-write]
module.primary.data.aws_caller_identity.account: Refreshing state... [id=804916306882]
module.primary.module.iam.data.aws_iam_policy_document.lvs_dns_sts: Refreshing state... [id=482462590]
module.primary.module.zone.aws_route53_zone.service: Refreshing state... [id=Z08845921QN18TGF9V65U]
aws_iam_role_policy_attachment.mgmt_s3_full_access_attachment: Refreshing state... [id=tf-pop-dns-mgmt-20201202004506590200000003]
aws_iam_role_policy_attachment.pop_dns_readonly_attachment: Refreshing state... [id=twitch-pop-warp-dns-20201202001541845500000002]
aws_iam_policy.sts_assume_role: Refreshing state... [id=arn:aws:iam::804916306882:policy/twitch-pop-warp-dns-mgmt-assumerole]
aws_iam_role_policy_attachment.mgmt_readonly_attachment: Refreshing state... [id=tf-pop-dns-mgmt-20201202004506588000000001]
data.aws_caller_identity.current: Refreshing state... [id=804916306882]
module.primary.module.iam.aws_iam_role.lvs_dns_delegation: Refreshing state... [id=lvs-dns-delegation]
aws_iam_role_policy_attachment.sts_assume_role_attachment: Refreshing state... [id=tf-pop-dns-mgmt-20201202003934241300000001]
aws_iam_role_policy_attachment.tf_dynamodb_write_attachment: Refreshing state... [id=tf-pop-dns-mgmt-20201202003934246900000002]
module.primary.module.iam.aws_iam_role_policy_attachment.readonly: Refreshing state... [id=lvs-dns-delegation-20201202001542665000000003]
aws_iam_policy.pop_warp_crud_policy: Refreshing state... [id=arn:aws:iam::804916306882:policy/twitch-pop-warp-dns-route53]
aws_iam_role_policy_attachment.pop_dns_crud_attachment: Refreshing state... [id=twitch-pop-warp-dns-20201202004127089400000001]

------------------------------------------------------------------------

No changes. Infrastructure is up-to-date.

This means that Terraform did not detect any differences between your
configuration and real physical resources that exist. As a result, no
actions need to be performed.
```
