#!/usr/bin/env bash

set -eo pipefail

# twitch-video-coreservices+warp-dns@amazon.com
AWS_ACCOUNT_ID="804916306882"

export AWS_STS_REGIONAL_ENDPOINTS=regional

usage() {
    cat <<EOF
Usage: $0 <command> [args ...]

  <command> [args ...]
    In general, these are command and args that are passed to terraform binary as
    arguments

    E.g.
      $0 plan

      gets passed to terraform as

      terraform plan
EOF
    exit 1
}

requirements() {
    command -v tfenv &> /dev/null || ( echo "tfenv required but missing" && usage )
}

tf_init() {
    shift
    terraform init "$@" -reconfigure
}

validate_account() {
    if ! [[ "$AWS_ACCOUNT_ID" == "$(aws sts get-caller-identity | jq -r .Account)" ]]; then
        err "$(cat <<EOF
  Your current credentials do not match account '${AWS_ACCOUNT_ID}' that manages this environment and region
  Please double check that you are using the correct credentials for the correct account.
EOF
)"
        usage
    fi
}

# Print usage if no arguments or -h is given
[[ "$#" -lt 1 || "$1" == "-h" ]] && usage

requirements
validate_account

case "$1" in
    init)
        tf_init "$@"
        ;;
    plan|apply)
        tf_init "$@"
        exec terraform "$@"
        ;;
    *)
        exec terraform "$@"
        ;;
esac
