variable "service" {
  description = "The name of the service"
  default     = "warp"
}

module "primary" {
  source  = "git@git.xarth.tv:video-coreservices/tf-mod-live-video-dns-delegation.git//primary?ref=v1.0.7"
  service = "warp"
  domain  = "live-video.net"

  comment = "${title(var.service)} Service Primary DNS"

  tags = {
    Owner       = "video-coreservices@twitch.tv"
    Environment = "prod"
    Service     = "warp-dns"
    Src         = "video-coreservices/tf-io-warp-dns"
  }
}

output "primary" {
  value = module.primary
}
