# tf-mod-alerta-cloudwatch-integration

Sets up the resources to allow you to publish cloudwatch alarms to the central alerta API

## Usage

* **Developers**: Just include the module in your account's terraform. Then, open a VIDCS ticket to add your service to alerting with the tf output attached to the ticket description.

```hcl
module "service_alerta" {
  source  = "git@git.xarth.tv:video-coreservices/tf-mod-alerta-cloudwatch-integration.git//primary?ref=v1.0.0"
  service = var.service
  region  = var.region
  env     = var.env
}
```


* **VIDCS**:
  All work will be done using the alerta account's isengard credentials loaded into your shell session in the  https://git.xarth.tv/video-coreservices/tf-io-alerta repo:

  1. Add the output ARN to the list of ARNs for the `account_topics` variable under `conf/<env>/variables.tfvars`
  2. Run `./deploy.sh -e <alerta-env>` using the credentials for the alerta account (will be twitch-vidops-aws when in prod)
  3. Run `./add-service-to-queue.sh <output-arn>` using the credentials for the alerta account (will be twitch-vidops-aws when in prod)
