resource "aws_sns_topic" "alerta_cloudwatch_topic" {
  name = "${var.service}-alerta"
}

resource "aws_sns_topic_policy" "alerta_cloudwatch_topic_policy" {
  arn    = aws_sns_topic.alerta_cloudwatch_topic.arn
  policy = data.aws_iam_policy_document.alerta_sns_policy.json
}

# Get current account data
data "aws_caller_identity" "current" {}

data "aws_iam_policy_document" "alerta_sns_policy" {
  # Allow any cloudwatch alarms to do things with the topic
  statement {
    sid = "__default_statement_ID"

    actions = [
      "SNS:Publish",
      "SNS:RemovePermission",
      "SNS:SetTopicAttributes",
      "SNS:DeleteTopic",
      "SNS:ListSubscriptionsByTopic",
      "SNS:GetTopicAttributes",
      "SNS:Receive",
      "SNS:AddPermission",
      "SNS:Subscribe"
    ]
    effect = "Allow"

    principals {
      type        = "AWS"
      identifiers = ["*"]
    }

    resources = [
      aws_sns_topic.alerta_cloudwatch_topic.arn,
    ]

    condition {
      test     = "StringEquals"
      variable = "AWS:SourceOwner"
      values   = [data.aws_caller_identity.current.account_id]
    }


  }

  # Allow central alerta account
  statement {
    sid = "AllowCentralAlerta"
    
    actions = [
      "SNS:Subscribe",
      "SNS:Receive",
    ]

    effect = "Allow"

    principals {
      type        = "AWS"
      identifiers = ["arn:aws:iam::152548578290:root"] # vidops-stg, change to prod for prod release
    }

    resources = [
      aws_sns_topic.alerta_cloudwatch_topic.arn,
    ]
  }
}
