locals {
  dns_entry_index = var.use_zonal_endpoint ? 1 : 0
  records         = toset([var.zone_name, "*.${var.zone_name}"])

  vpcs = concat(var.associate_vpcs, [{ id = var.vpc_id }])
}

resource "aws_vpc_endpoint" "this" {
  vpc_id            = var.vpc_id
  service_name      = var.vpce_service_name
  vpc_endpoint_type = "Interface"

  subnet_ids         = var.subnet_ids
  security_group_ids = var.security_group_ids

  private_dns_enabled = false
}

resource "aws_route53_zone" "this" {
  name = var.zone_name

  force_destroy = true

  dynamic "vpc" {
    for_each = local.vpcs

    content {
      vpc_id     = vpc.value.id
      vpc_region = lookup(vpc.value, "region", null)
    }
  }
}

resource "aws_route53_record" "record" {
  for_each = local.records

  zone_id = aws_route53_zone.this.zone_id
  name    = each.value
  type    = "A"

  alias {
    name                   = aws_vpc_endpoint.this.dns_entry[local.dns_entry_index].dns_name
    zone_id                = aws_vpc_endpoint.this.dns_entry[local.dns_entry_index].hosted_zone_id
    evaluate_target_health = var.evaluate_target_health
  }
}
