variable "zone_name" {
  type        = string
  default     = "pkgs.xarth.tv"
  description = "Private Zone created for use with Artifactory (might have to match TLS name)"
}

variable "vpce_service_name" {
  type        = string
  default     = "com.amazonaws.vpce.us-west-2.vpce-svc-0ae1454184d60ff60"
  description = "Artifactory VPC Endpoint Service Name"
}

variable "vpc_id" {
  type        = string
  description = "VPC ID to use for VPC Endpoint"
}

variable "associate_vpcs" {
  type        = list(map(string))
  default     = []
  description = "Secondary VPCs to associate the Private zone with. By default vpc_id is associated."
}

variable "subnet_ids" {
  type        = list(string)
  description = "Subnet IDs for VPC Endpoint"
}

variable "security_group_ids" {
  type        = list(string)
  description = "Security Group IDs for VPC Endpoint"
}

variable "use_zonal_endpoint" {
  type        = bool
  default     = false
  description = "Use zonal endpoint name instead of regional name (if you only use 1 AZ, this is useful for reducing inter-az costs)"
}

variable "evaluate_target_health" {
  type        = bool
  default     = false
  description = "Evaluate target health for VPC endpoint"
}
