# Terraform Account Bootstrapping

Bootstrap an account to be able to run Terraform.

* Creates S3 bucket to store terraform state files
* Creates a dynamodb table for terraform locks

## TOC

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Usage](#usage)
- [Requirements](#requirements)
- [Deployment](#deployment)
  - [Example](#example)
- [Development](#development)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Usage

## Requirements
* [tfenv](https://github.com/tfutils/tfenv#automatic)
* AWS credentials to the account you would want to like boostrap terraform changes.

## Deployment

To deploy this change:

```bash
  ./deploy.sh -s <service> -e <env> -r <region> <plan|apply>

  <service>
    The name of the service. E.g. puppet
  <region>
    This should be a valid AWS region. E.g. us-west-2
  <env>
    This should be either dev, staging, or prod
```

**Note**: This will create a local terraform state file with the following name: `<AWS_ACCOUNT_ID>-<service>-<region>-<env>.tfstate`.

### Example

```terraform
> ./deploy.sh -s metrics -r us-west-2 -e prod plan

Initializing the backend...

Initializing provider plugins...

Terraform has been successfully initialized!

You may now begin working with Terraform. Try running "terraform plan" to see
any changes that are required for your infrastructure. All Terraform commands
should now work.

If you ever set or change modules or backend configuration for Terraform,
rerun this command to reinitialize your working directory. If you forget, other
commands will detect it and remind you to do so if necessary.
Refreshing Terraform state in-memory prior to plan...
The refreshed state will be used to calculate this plan, but will not be
persisted to local or remote state storage.


------------------------------------------------------------------------

An execution plan has been generated and is shown below.
Resource actions are indicated with the following symbols:
  + create

Terraform will perform the following actions:

  # aws_dynamodb_table.terraform_locks will be created
  + resource "aws_dynamodb_table" "terraform_locks" {
      + arn              = (known after apply)
      + billing_mode     = "PAY_PER_REQUEST"
      + hash_key         = "LockID"
      + id               = (known after apply)
      + name             = "terraform_locks"
      + stream_arn       = (known after apply)
      + stream_label     = (known after apply)
      + stream_view_type = (known after apply)

      + attribute {
          + name = "LockID"
          + type = "S"
        }

      + point_in_time_recovery {
          + enabled = (known after apply)
        }

      + server_side_encryption {
          + enabled     = (known after apply)
          + kms_key_arn = (known after apply)
        }
    }

  # aws_s3_bucket.service will be created
  + resource "aws_s3_bucket" "service" {
      + acceleration_status         = (known after apply)
      + acl                         = "private"
      + arn                         = (known after apply)
      + bucket                      = "metrics-us-west-2-prod-tf-state"
      + bucket_domain_name          = (known after apply)
      + bucket_regional_domain_name = (known after apply)
      + force_destroy               = false
      + hosted_zone_id              = (known after apply)
      + id                          = (known after apply)
      + region                      = (known after apply)
      + request_payer               = (known after apply)
      + tags                        = {
          + "Environment" = "prod"
          + "Owner"       = "video-coreservices@twitch.tv"
          + "Service"     = "metrics"
        }
      + website_domain              = (known after apply)
      + website_endpoint            = (known after apply)

      + server_side_encryption_configuration {
          + rule {
              + apply_server_side_encryption_by_default {
                  + sse_algorithm = "AES256"
                }
            }
        }

      + versioning {
          + enabled    = true
          + mfa_delete = false
        }
    }

Plan: 2 to add, 0 to change, 0 to destroy.
```

## Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).

Run `pre-commit install` to install `pre-commit` hook.
