terraform {
  required_version = "=0.12.29"
}

provider "aws" {
  region  = var.region
  version = "~> 3.7.0"
}

resource "aws_s3_bucket" "service" {
  bucket = "${var.service}-${var.region}-${var.env}-tf-state"
  acl    = "private"

  versioning {
    enabled = true
  }

  server_side_encryption_configuration {
    rule {
      apply_server_side_encryption_by_default {
        sse_algorithm = "AES256"
      }
    }
  }

  tags = {
    Environment = var.env
    Service     = var.service
    Owner       = "video-coreservices@twitch.tv"
  }
}

resource "aws_dynamodb_table" "terraform_locks" {
  name         = "terraform_locks"
  billing_mode = "PAY_PER_REQUEST"

  hash_key = "LockID"

  attribute {
    name = "LockID"
    type = "S"
  }
}
