# CloudwatchWiki Terraform module

This module setups the following:
* Necessary permissions to display Cloudwatch dashboards in w.amazon.com. More info [here](https://w.amazon.com/index.php/CloudWatch/Dashboards).
  * This utilizes CFN template provided by this [package](https://code.amazon.com/packages/CloudWatchDashboards-Wiki-CFN-Template/trees/mainline).
* Necessary permissions to setup cross account metrics to other "monitoring account".
  * This is based from this [public guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Cross-Account-Cross-Region.html) which provices a CFN template that can be used.
  * Defaults to grant _full_ RO access to all logs to the Video Ops Party _Metrics_ account.


<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Usage](#usage)
- [Terraform](#terraform)
  - [Requirements](#requirements)
  - [Providers](#providers)
  - [Modules](#modules)
  - [Inputs](#inputs)
  - [Outputs](#outputs)
- [Development](#development)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

# Usage

Declare the module as follows. E.g.:

```terraform
module "cloudwatch_wiki" {
  source = "git@git.xarth.tv:video-coreservices/tf-mod-cloudwatchdashboards-wiki.git?ref=<RELEASE>"
  region = "<AWS_REGION>"
}
```

Refer additional information about variables below.

# Terraform
<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
## Requirements

No requirements.

## Providers

| Name | Version |
|------|---------|
| <a name="provider_aws"></a> [aws](#provider\_aws) | n/a |
| <a name="provider_local"></a> [local](#provider\_local) | n/a |

## Modules

No modules.

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_allow_edit_through_wiki"></a> [allow\_edit\_through\_wiki](#input\_allow\_edit\_through\_wiki) | Selecting true will give wiki users permissions to change the dashboard from inside the wiki | `bool` | `false` | no |
| <a name="input_allow_log_access"></a> [allow\_log\_access](#input\_allow\_log\_access) | Selecting true will enable Log widgets to be displayed, plus give wiki users permissions to look inside all CloudWatch Logs in your account | `bool` | `true` | no |
| <a name="input_cross_account_cloudwatch_account_ids"></a> [cross\_account\_cloudwatch\_account\_ids](#input\_cross\_account\_cloudwatch\_account\_ids) | Allows one or more monitoring accounts to view your data. Enter AWS account ids, 12 numeric digits in a list. Defaults to Video Ops Prod _Metrics_ account - twitch-bs-video-ops-aws@amazon.com | `list(string)` | <pre>[<br>  "277437172290"<br>]</pre> | no |
| <a name="input_region"></a> [region](#input\_region) | The AWS region to deploy this stack changes to | `string` | n/a | yes |

## Outputs

No outputs.
<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->

# Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)

Run `pre-commit install` to install `pre-commit` hook.
