terraform {
  required_providers {
    aws = {}
  }
}

# Permit CW metrics to w.amazon.com
data "local_file" "cloudformation_template" {
  filename = "${path.module}/files/CloudWatchDashboardsWiki.template.json"
}

resource "aws_cloudformation_stack" "cloudwatchdashboard_wiki_configuration" {
  name = "cloudwatch-dashboard-wiki"

  template_body = data.local_file.cloudformation_template.content

  capabilities = ["CAPABILITY_NAMED_IAM"]

  parameters = {
    AllowEditThroughWiki        = var.allow_edit_through_wiki ? "Yes" : "No"
    AllowLogAccess              = var.allow_log_access ? "Yes" : "No"
    LambdaInvokeFunctionPrefix  = "cwwiki"
    OwnCloudWatchDashboardsRole = "Yes"
  }

  # Set termination protection else policy engine gets fired
  # https://github.com/hashicorp/terraform-provider-aws/issues/3496
  provisioner "local-exec" {
    command = "AWS_REGION=${var.region} aws cloudformation update-termination-protection --stack-name ${self.name} --enable-termination-protection"
  }
}

# Permit Cross account sharing
data "local_file" "cloudformation_template_xa" {
  filename = "${path.module}/files/CloudWatch-CrossAccountSharingRole-AccountList-aws.yaml"
}

resource "aws_cloudformation_stack" "cross_account_cloudwatch_configuration" {
  name = "CloudWatch-CrossAccountSharingRole"

  template_body = data.local_file.cloudformation_template_xa.content

  capabilities = ["CAPABILITY_NAMED_IAM"]

  parameters = {
    MonitoringAccountIds = join(",", var.cross_account_cloudwatch_account_ids)
    Policy               = "View-Access-for-all-services"
  }

  # Set termination protection else policy engine gets fired
  # https://github.com/hashicorp/terraform-provider-aws/issues/3496
  provisioner "local-exec" {
    command = "AWS_REGION=${var.region} aws cloudformation update-termination-protection --stack-name ${self.name} --enable-termination-protection"
  }
}
