variable "region" {
  type        = string
  description = "The AWS region to deploy this stack changes to"
}

variable "allow_edit_through_wiki" {
  type        = bool
  description = "Selecting true will give wiki users permissions to change the dashboard from inside the wiki"
  default     = false
}

variable "allow_log_access" {
  type        = bool
  description = "Selecting true will enable Log widgets to be displayed, plus give wiki users permissions to look inside all CloudWatch Logs in your account"
  default     = true
}

variable "cross_account_cloudwatch_account_ids" {
  type        = list(string)
  description = "Allows one or more monitoring accounts to view your data. Enter AWS account ids, 12 numeric digits in a list. Defaults to Video Ops Prod _Metrics_ account - twitch-bs-video-ops-aws@amazon.com"
  default     = ["277437172290"]
}
