# tf-mod-datacenters-metadata
Terraform outputs of known datacenters

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Usage](#usage)
  - [Requirements](#requirements)
  - [Outputs](#outputs)
- [Making Changes](#making-changes)
- [Development](#development)
  - [Testing](#testing)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Usage

Consumers of this repository is expected to use the `main` branch, as this holds the source of valid datacenters.

```terraform
module "edge_pops" {
  source = "git@git.xarth.tv:video-coreservices/tf-mod-datacenters-metadata.git"
}
```

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
### Requirements

| Name | Version |
|------|---------|
| terraform | >= 0.12.0 |

### Outputs

| Name | Description |
|------|-------------|
| all\_datacenters | A list of all datacenters (including origins and edges). |
| datacenters\_map | The raw map of datacenters and its attributes. Useful if the existing outputs do not provide the necessary transformation required. |
| edge\_datacenters | A list of edge datacenters aka POPs. |
| edge\_datacenters\_decommissioned | A list of edge datacenters that are physically decommissioned. |
| edge\_datacenters\_in\_commission | A list of edge datacenters that are physically in commission. |
| global\_map\_by\_datacenters | A map of datacenters grouped by regions, by edge/origin/all. |
| global\_map\_by\_datacenters\_decommissioned | A map of physically decommissioned datacenters grouped by regions, by edge/origin/all. |
| global\_map\_by\_datacenters\_in\_commission | A map of physically in commission datacenters grouped by regions, by edge/origin/all. |
| global\_map\_by\_regions | A map of datacenters grouped by AWS regions, by edge/origin/all. |
| global\_map\_by\_regions\_decommissioned | A map of physically decommissioned datacenters grouped by AWS regions, by edge/origin/all. |
| global\_map\_by\_regions\_in\_commission | A map of physically in commission datacenters grouped by AWS regions, by edge/origin/all. |
| origin\_datacenters | A list of origin datacenters. |
| origin\_datacenters\_decommissioned | A list of origin datacenters that are physically decommissioned. |
| origin\_datacenters\_in\_commission | A list of origin datacenters that are physically in commission. |

<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->

## Making Changes

A list of valid pops is maintained so that no accidental pops are delegated in [video-coreservices/tf-io-pop-delegation](https://git.xarth.tv/video-coreservices/tf-io-dns-pop-delegation).

1. To add new pops, modify `datacenters` under [`variables.tf`](variables.tf) to include the new pop to be managed.
1. Create a PR for approval.
1. Proceed to the [video-coreservices/tf-io-pop-delegation](https://git.xarth.tv/video-coreservices/tf-io-dns-pop-delegation) to plan, validate intended changes, and apply.

## Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)

Run `pre-commit install` to install `pre-commit` hook.

### Testing

There is a pre-commit hook which runs and validate the desired output under [tests](tests/validate_output.sh)
