#!/usr/bin/env bash
set -e -o pipefail

# Make sure we're running against the correct terraform
command -v tfenv > /dev/null

tfvars="$1"
diff_file="$2"

[[ -f "$tfvars" && -f "$diff_file" ]]

tmp_tfstate=$(mktemp -t tfmod-dc-meta)

function finish {
  rm -f "$tmp_tfstate"
}

trap finish EXIT

terraform apply -state="$tmp_tfstate" -auto-approve -var-file="$tfvars" -auto-approve &> /dev/null

# There should be no diff
diff <(terraform output -state="$tmp_tfstate") "$diff_file" || \
  ( echo "Terraform output vs test output differs!! Validate code or update test output" && \
    cp -a "$tmp_tfstate" "${tmp_tfstate}.saved" && \
    echo "Compare output via terraform output -state=${tmp_tfstate}.saved" && \
    exit 1 \
  )
