variable "datacenters" {
  description = "A map of datacenters and its attributes"

  type = map(object({
    in_commission = bool
    edge          = bool
    origin        = bool
    aws_region    = string
  }))

  default = {
    # Origin DCs
    ams04 = { in_commission = true, edge = false, origin = true, aws_region = "eu-central-1" }
    cmh01 = { in_commission = true, edge = false, origin = true, aws_region = "us-east-2" }
    iad06 = { in_commission = true, edge = false, origin = true, aws_region = "us-east-1" }
    lhr05 = { in_commission = true, edge = false, origin = true, aws_region = "eu-west-2" } # NOTE: puppet facter maps this to eu-west-1
    pdx05 = { in_commission = true, edge = false, origin = true, aws_region = "us-west-2" }
    sin03 = { in_commission = true, edge = false, origin = true, aws_region = "ap-southeast-1" }
    sjc02 = { in_commission = false, edge = false, origin = true, aws_region = "us-west-2" }

    # Edge DCs
    ams02 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    ams03 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    arn03 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    atl01 = { in_commission = true, edge = true, origin = false, aws_region = "us-east-1" }
    ber01 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    bkk01 = { in_commission = true, edge = true, origin = false, aws_region = "ap-southeast-1" }
    blr01 = { in_commission = true, edge = true, origin = false, aws_region = "ap-southeast-1" }
    bom01 = { in_commission = true, edge = true, origin = false, aws_region = "ap-southeast-1" }
    cdg02 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    cdg10 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    cph01 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    del01 = { in_commission = true, edge = true, origin = false, aws_region = "ap-southeast-1" }
    den01 = { in_commission = true, edge = true, origin = false, aws_region = "us-east-2" }
    dfw02 = { in_commission = true, edge = true, origin = false, aws_region = "us-east-1" }
    dus01 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    fra02 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    fra05 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    fra06 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    for01 = { in_commission = true, edge = true, origin = false, aws_region = "us-east-1" }
    hel01 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    hkg01 = { in_commission = true, edge = true, origin = false, aws_region = "ap-southeast-1" }
    hkg06 = { in_commission = true, edge = true, origin = false, aws_region = "ap-southeast-1" }
    hyd01 = { in_commission = true, edge = true, origin = false, aws_region = "ap-southeast-1" }
    hou01 = { in_commission = true, edge = true, origin = false, aws_region = "us-west-2" }
    iad03 = { in_commission = true, edge = true, origin = false, aws_region = "us-east-1" }
    iad05 = { in_commission = true, edge = true, origin = false, aws_region = "us-east-1" }
    jfk04 = { in_commission = true, edge = true, origin = false, aws_region = "us-east-1" }
    jfk06 = { in_commission = true, edge = true, origin = false, aws_region = "us-east-1" }
    lax03 = { in_commission = true, edge = true, origin = false, aws_region = "us-west-2" }
    lhr03 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    lhr04 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    maa01 = { in_commission = true, edge = true, origin = false, aws_region = "ap-southeast-1" }
    mad01 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    mia02 = { in_commission = false, edge = true, origin = false, aws_region = "us-east-1" }
    mia05 = { in_commission = true, edge = true, origin = false, aws_region = "us-east-1" }
    mil01 = { in_commission = false, edge = true, origin = false, aws_region = "eu-west-1" }
    mil02 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    mrs01 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    mrs02 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    ord02 = { in_commission = true, edge = true, origin = false, aws_region = "us-east-2" }
    ord03 = { in_commission = true, edge = true, origin = false, aws_region = "us-east-2" }
    osl01 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    pdx01 = { in_commission = true, edge = true, origin = false, aws_region = "us-west-2" }
    phx01 = { in_commission = true, edge = true, origin = false, aws_region = "us-west-2" }
    prg02 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    qro01 = { in_commission = true, edge = true, origin = false, aws_region = "us-east-1" }
    qro02 = { in_commission = true, edge = true, origin = false, aws_region = "us-east-1" }
    rio01 = { in_commission = true, edge = true, origin = false, aws_region = "us-east-1" }
    sao01 = { in_commission = true, edge = true, origin = false, aws_region = "us-east-1" }
    sea01 = { in_commission = true, edge = true, origin = false, aws_region = "us-west-2" }
    sel01 = { in_commission = true, edge = true, origin = false, aws_region = "ap-southeast-1" }
    sel03 = { in_commission = true, edge = true, origin = false, aws_region = "ap-southeast-1" }
    sin01 = { in_commission = true, edge = true, origin = false, aws_region = "ap-southeast-1" }
    sjc05 = { in_commission = true, edge = true, origin = false, aws_region = "us-west-2" }
    slc01 = { in_commission = true, edge = true, origin = false, aws_region = "us-west-2" }
    syd01 = { in_commission = true, edge = true, origin = false, aws_region = "us-west-2" }
    syd02 = { in_commission = true, edge = true, origin = false, aws_region = "us-west-2" }
    tpe01 = { in_commission = true, edge = true, origin = false, aws_region = "ap-southeast-1" }
    tpe03 = { in_commission = true, edge = true, origin = false, aws_region = "ap-southeast-1" }
    tyo01 = { in_commission = true, edge = true, origin = false, aws_region = "ap-southeast-1" }
    tyo03 = { in_commission = true, edge = true, origin = false, aws_region = "ap-southeast-1" }
    tyo05 = { in_commission = true, edge = true, origin = false, aws_region = "ap-southeast-1" }
    vie01 = { in_commission = false, edge = true, origin = false, aws_region = "eu-west-1" }
    vie02 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    waw01 = { in_commission = true, edge = true, origin = false, aws_region = "eu-west-1" }
    ymq01 = { in_commission = true, edge = true, origin = false, aws_region = "us-east-2" }
    yto01 = { in_commission = true, edge = true, origin = false, aws_region = "us-east-2" }
  }
}
