## DNS SQS Lambda Pipeline

This module bootstraps the lambda that will serve DNS updates for a given subdomain as well as the notification resources that surround it. This module is intended to be included for each subdomain that may be managed by the DNS updater notification pipeline (e.g: warp, ttvnw.net subdomains).

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Requirements](#requirements)
- [Providers](#providers)
- [Modules](#modules)
- [Inputs](#inputs)
- [Outputs](#outputs)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
## Requirements

No requirements.

## Providers

| Name | Version |
|------|---------|
| <a name="provider_archive"></a> [archive](#provider\_archive) | n/a |
| <a name="provider_aws"></a> [aws](#provider\_aws) | n/a |
| <a name="provider_random"></a> [random](#provider\_random) | n/a |

## Modules

No modules.

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_codesource_bucket_id"></a> [codesource\_bucket\_id](#input\_codesource\_bucket\_id) | The name of your S3 bucket. | `string` | n/a | yes |
| <a name="input_codesource_bucket_subfolder"></a> [codesource\_bucket\_subfolder](#input\_codesource\_bucket\_subfolder) | The name of your S3 bucket. | `string` | `"main"` | no |
| <a name="input_crud_allowlist"></a> [crud\_allowlist](#input\_crud\_allowlist) | List of machine classes the lambda pipeline supports. Ex: ["video-edge", "video-warp"]. | `list(string)` | n/a | yes |
| <a name="input_dns_updater_role"></a> [dns\_updater\_role](#input\_dns\_updater\_role) | The ARN of the IAM role created in the DNS account that hosts the subdomain that allows R53 CRUD operations. | `string` | n/a | yes |
| <a name="input_env"></a> [env](#input\_env) | Service environment - (prod\|staging). | `string` | `"staging"` | no |
| <a name="input_input_sns_arn"></a> [input\_sns\_arn](#input\_input\_sns\_arn) | The ARN of the SNS topic that will send jobs to the SQS pipeline. | `string` | n/a | yes |
| <a name="input_pd_url"></a> [pd\_url](#input\_pd\_url) | The pagerduty URL alarms for the stack should send to. | `string` | n/a | yes |
| <a name="input_pop_subdomain"></a> [pop\_subdomain](#input\_pop\_subdomain) | Whether to prepend the target\_dns\_domain with POP (i.e. <pop>.<target\_dns\_domain>, or only use target\_dns\_domain | `bool` | `true` | no |
| <a name="input_region"></a> [region](#input\_region) | The AWS region this service will be deployed. | `string` | `"us-west-2"` | no |
| <a name="input_repo_src"></a> [repo\_src](#input\_repo\_src) | The git source of your terraform. Used to tag taggable resources. | `any` | n/a | yes |
| <a name="input_service_id"></a> [service\_id](#input\_service\_id) | The name of your application. | `string` | n/a | yes |
| <a name="input_target_dns_domains"></a> [target\_dns\_domains](#input\_target\_dns\_domains) | The 'root' subdomains this DNS pipeline is responsible for updating. Ex: warp.live-video.net, abs.ttvnw.net. | `list(string)` | n/a | yes |
| <a name="input_ttl"></a> [ttl](#input\_ttl) | The ttl for the generated DNS record | `number` | `300` | no |

## Outputs

| Name | Description |
|------|-------------|
| <a name="output_service_codesource_bucket"></a> [service\_codesource\_bucket](#output\_service\_codesource\_bucket) | The bucket name where the lambda source code is stored. |
| <a name="output_service_lambda_arn"></a> [service\_lambda\_arn](#output\_service\_lambda\_arn) | The ARN of the lambda created from this module. |
| <a name="output_service_lambda_source_code_filename"></a> [service\_lambda\_source\_code\_filename](#output\_service\_lambda\_source\_code\_filename) | The ARN of the lambda created from this module. |
| <a name="output_service_queue_arn"></a> [service\_queue\_arn](#output\_service\_queue\_arn) | The ARN of the the SQS queue that the lambda will pull jobs from |
<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
