# iam role for lambda so it can integrate with sqs and push messages to sns
resource "aws_iam_role" "service_lambda_role" {
  name               = "${var.service_id}-lambda-role"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
  {
    "Effect": "Allow",
    "Principal": {
      "Service": "lambda.amazonaws.com"
    },
    "Action": "sts:AssumeRole"
  }
 ]
}
EOF
}

resource "aws_iam_policy" "service_lambda_policy" {
  name        = "${var.service_id}-perms"
  description = "Allows the ${var.service_id} DNS updater lambda to talk to the sqs queues and to AssumeRole to perform CRUD updates on R53"
  policy      = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
         "sqs:ReceiveMessage",
         "sqs:DeleteMessage",
         "sqs:GetQueueAttributes"
       ],
      "Resource": [
        "${aws_sqs_queue.service_queue.arn}"
      ]
    },
    {
      "Effect": "Allow",
      "Action": [
        "logs:CreateLogGroup",
        "logs:CreateLogStream",
        "logs:PutLogEvents"
      ],
      "Resource": "*"
    },
    {
      "Sid": "AllowSTSRoute53",
      "Effect": "Allow",
      "Action": "sts:AssumeRole",
      "Resource": "${var.dns_updater_role}"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "service_lambda_policy_attachment" {
  role       = aws_iam_role.service_lambda_role.name
  policy_arn = aws_iam_policy.service_lambda_policy.arn
}
