# The lambda that performs DNS CRUD operations
resource "aws_lambda_function" "service_dns_lambda" {
  function_name = "${var.service_id}_lambda"
  filename      = "${path.module}/files/StubLambda.zip" # This intializes the lambda but deploys/changes will be carried out by the push to the S3 codesource.
  role          = aws_iam_role.service_lambda_role.arn
  handler       = "dns_updater.lambda_handler"
  publish       = true
  runtime       = "python3.7"

  timeout = 60

  environment {
    variables = {
      TARGET_DNS_DOMAINS         = join(",", var.target_dns_domains)
      R53_ASSUME_ROLE            = var.dns_updater_role
      ALLOW_LIST_MACHINE_CLASSES = join("|", var.crud_allowlist)
      POP_SUBDOMAIN              = var.pop_subdomain
      TTL                        = var.ttl
    }
  }

  lifecycle {
    ignore_changes = [
      # Ignore changes to version and qualified_arn, as those are managed by codedeploy
      qualified_arn,
      version,
    ]
  }
}

# create prod alias
resource "aws_lambda_alias" "service_prod_alias" {
  name             = "PROD"
  description      = "Alias pointing the lambda to the PROD version"
  function_name    = aws_lambda_function.service_dns_lambda.arn
  function_version = aws_lambda_function.service_dns_lambda.version

  lifecycle {
    ignore_changes = [
      # Ignore changes to version, as those are managed by codedeploy
      function_version,
      routing_config,
    ]
  }
}

# default event source mapping
resource "aws_lambda_event_source_mapping" "sqs_to_service" {
  event_source_arn = aws_sqs_queue.service_queue.arn
  function_name    = aws_lambda_alias.service_prod_alias.arn
  batch_size       = 1
}
