import boto3
import os
import pytest

from moto import mock_route53

AWS_REGION = "us-west-2"


@pytest.fixture
def aws_credentials():
    """Mocked AWS Credentials for moto."""
    os.environ["AWS_ACCESS_KEY_ID"] = "testing"
    os.environ["AWS_SECRET_ACCESS_KEY"] = "testing"
    os.environ["AWS_SECURITY_TOKEN"] = "testing"
    os.environ["AWS_SESSION_TOKEN"] = "testing"


@pytest.fixture
def r53_client(aws_credentials):
    with mock_route53():
        conn = boto3.client("route53")
        yield conn
