# topic and subscription to allow these alarms to send to our pagerduty
resource "aws_sns_topic" "cw_alarm_topic" {
  name = "${var.service_id}-alarm-topic"
}

resource "aws_sns_topic_subscription" "cw_alarm_subscription" {
  topic_arn              = aws_sns_topic.cw_alarm_topic.arn
  protocol               = "https"
  endpoint               = var.pd_url
  endpoint_auto_confirms = true
}

resource "aws_cloudwatch_metric_alarm" "deadletter_alarm" {
  alarm_name          = "${var.region}-${local.environment} ${var.service_id} SQS deadletter queue has message(s)"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "2"
  metric_name         = "ApproximateNumberOfMessagesVisible"
  namespace           = "AWS/SQS"
  statistic           = "Sum"
  period              = "60"
  threshold           = "1"
  alarm_description   = "${var.region}-${local.environment} ${var.service_id} SQS deadletter queue has message(s)."
  alarm_actions       = [aws_sns_topic.cw_alarm_topic.arn]
  ok_actions          = [aws_sns_topic.cw_alarm_topic.arn]

  dimensions = {
    QueueName = aws_sqs_queue.service_deadletter.name
  }
}
