resource "aws_s3_bucket" "service_codesource_bucket" {
  bucket = var.codesource_bucket_id
  acl    = "private"

  versioning {
    enabled = true
  }
}

locals {
  src_dir   = "${path.module}/lambda"
  build_dir = "${path.module}/build"
}

# Ensure new archive is only uploaded on python code changes
resource "random_uuid" "lambda_src_hash" {
  keepers = {
    for filename in setunion(
      fileset(local.src_dir, "*.py"),
      fileset(local.src_dir, "requirements.txt"),
    ) :
    filename => filemd5("${local.src_dir}/${filename}")
  }
}

data "archive_file" "lambda_code" {
  type        = "zip"
  source_dir  = local.src_dir
  output_path = "${local.build_dir}/${random_uuid.lambda_src_hash.result}.zip"
  excludes    = [".pytest_cache", "requirements-dev.txt", "tests"]
}


resource "aws_s3_bucket_object" "lambda_zip_to_codesource" {
  bucket     = var.codesource_bucket_id
  key        = "${var.codesource_bucket_subfolder}/SourceArtifact.zip"
  source     = "${local.build_dir}/${random_uuid.lambda_src_hash.result}.zip"
  depends_on = [aws_s3_bucket.service_codesource_bucket]
}
