variable "env" {
  description = "Service environment - (prod|staging)."
  default     = "staging"
}

variable "region" {
  description = "The AWS region this service will be deployed."
  default     = "us-west-2"
}

variable "repo_src" {
  description = "The git source of your terraform. Used to tag taggable resources."
}

variable "service_id" {
  description = "The name of your application."
  type        = string
}

variable "codesource_bucket_id" {
  description = "The name of your S3 bucket."
  type        = string
}

variable "codesource_bucket_subfolder" {
  description = "The name of your S3 bucket."
  type        = string
  default     = "main"
}

variable "crud_allowlist" {
  description = "List of machine classes the lambda pipeline supports. Ex: [\"video-edge\", \"video-warp\"]."
  type        = list(string)
}

variable "dns_updater_role" {
  description = "The ARN of the IAM role created in the DNS account that hosts the subdomain that allows R53 CRUD operations."
  type        = string
}

variable "target_dns_domains" {
  description = "The 'root' subdomains this DNS pipeline is responsible for updating. Ex: warp.live-video.net, abs.ttvnw.net."
  type        = list(string)
}

variable "pop_subdomain" {
  description = "Whether to prepend the target_dns_domain with POP (i.e. <pop>.<target_dns_domain>, or only use target_dns_domain"
  type        = bool
  default     = true
}

variable "ttl" {
  description = "The ttl for the generated DNS record"
  type        = number
  default     = 300
}

variable "input_sns_arn" {
  description = "The ARN of the SNS topic that will send jobs to the SQS pipeline."
  type        = string
}

variable "pd_url" {
  description = "The pagerduty URL alarms for the stack should send to."
  type        = string
}

locals {
  environment_map = {
    prod    = "production"
    stage   = "staging"
    staging = "staging"
    dev     = "development"
  }

  environment = local.environment_map[var.env]

  common_tags = {
    Owner       = "video-coreservices@twitch.tv"
    Service     = var.service_id
    Environment = local.environment
    Source      = var.repo_src
  }
}
