data "aws_iam_policy_document" "ec2_assume" {
  statement {

    actions = ["sts:AssumeRole"]
    principals {
      type        = "Service"
      identifiers = ["ec2.amazonaws.com"]
    }
  }
}

data "aws_iam_policy" "ssm_managed_core" {
  name = "AmazonSSMManagedInstanceCore"
}

data "aws_ami" "al2" {
  owners      = ["amazon"]
  most_recent = true

  filter {
    name   = "name"
    values = ["amzn2-ami-hvm-2.0.*"]
  }

  filter {
    name   = "virtualization-type"
    values = ["hvm"]
  }

  filter {
    name   = "architecture"
    values = ["x86_64"]
  }
}

resource "aws_iam_instance_profile" "default" {
  name_prefix = var.iam_role_prefix
  role        = aws_iam_role.default.name
}

resource "aws_iam_role" "default" {
  name_prefix        = var.iam_role_prefix
  assume_role_policy = data.aws_iam_policy_document.ec2_assume.json
}

resource "aws_iam_role_policy_attachment" "ssm" {
  role       = aws_iam_role.default.name
  policy_arn = data.aws_iam_policy.ssm_managed_core.arn
}

resource "aws_instance" "default" {
  ami           = coalesce(var.ami, data.aws_ami.al2.id)
  instance_type = "t2.micro" # free tier eligible
  key_name      = aws_key_pair.default.key_name

  iam_instance_profile = aws_iam_instance_profile.default.name

  subnet_id              = var.subnet_id
  vpc_security_group_ids = var.security_group_ids

  instance_initiated_shutdown_behavior = "terminate"
}

resource "aws_key_pair" "default" {
  key_name   = "MySSHKey"
  public_key = file(pathexpand(var.public_key_file))
}
