variable "vpc_id" {
  type        = string
  description = "VPC ID for instance"
}

variable "subnet_id" {
  type        = string
  description = "Subnet ID for instance"
}

variable "security_group_ids" {
  type        = list(string)
  description = "Security Groups for instance"
}

variable "ami" {
  type        = string
  default     = null
  description = "AMI to use for instance"
}

variable "iam_role_prefix" {
  type        = string
  default     = "SimpleEc2Role"
  description = "Name Prefix used for created EC2 Role"
}

variable "public_key_file" {
  type        = string
  default     = "~/.ssh/id_rsa.pub"
  description = "Public Key File to create EC2 login key"
}
