# Self hosted Graphite Infrastructure Terraform Module

This is a terraform module that can be used to deploy graphite infrastructure.

You can see how to use this module in this [example](https://git.xarth.tv/video-coreservices/tf-io-graphite).

More information can be found in the [wiki](https://wiki.xarth.tv/display/VID/Self-hosted+graphite+infrastructure).

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Usage](#usage)
- [Terraform](#terraform)
  - [Requirements](#requirements)
  - [Providers](#providers)
  - [Inputs](#inputs)
  - [Outputs](#outputs)
- [Development](#development)
  - [Known Issues](#known-issues)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Usage

... Use release 1.0

```terraform
module "graphite" {
  source = "git@git.xarth.tv:video-coreservices/tf-mod-graphite-stack.git?ref=v1.0.0"

  ...
}
```


## Terraform

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
### Requirements

| Name | Version |
|------|---------|
| <a name="requirement_terraform"></a> [terraform](#requirement\_terraform) | >= 0.14.7 |
| <a name="requirement_aws"></a> [aws](#requirement\_aws) | >= 3.37.0 |
| <a name="requirement_template"></a> [template](#requirement\_template) | >= 2.1 |

### Providers

| Name | Version |
|------|---------|
| <a name="provider_aws"></a> [aws](#provider\_aws) | >= 3.37.0 |

### Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_carbon_c_relay_image_tag"></a> [carbon\_c\_relay\_image\_tag](#input\_carbon\_c\_relay\_image\_tag) | The image hash/tag that will be used to run carbon-c-relay | `string` | `"v3.7.2"` | no |
| <a name="input_carbon_c_relay_instance_type"></a> [carbon\_c\_relay\_instance\_type](#input\_carbon\_c\_relay\_instance\_type) | EC2 instance type to use for the carbon-c-relay containers | `string` | `"c5.xlarge"` | no |
| <a name="input_carbon_c_relay_node_count"></a> [carbon\_c\_relay\_node\_count](#input\_carbon\_c\_relay\_node\_count) | Number of nodes in the carbon-c-relay cluster | `any` | n/a | yes |
| <a name="input_ebs_iops"></a> [ebs\_iops](#input\_ebs\_iops) | iops limit for the ebs volumes. Anything above 3000 cost additional money. | `number` | `3000` | no |
| <a name="input_env"></a> [env](#input\_env) | Service environment - (prod\|stage) | `string` | `"stage"` | no |
| <a name="input_go_carbon_image_tag"></a> [go\_carbon\_image\_tag](#input\_go\_carbon\_image\_tag) | The image hash/tag that will be used to run go\_carbon | `string` | `"v0.15.6"` | no |
| <a name="input_go_carbon_instance_type"></a> [go\_carbon\_instance\_type](#input\_go\_carbon\_instance\_type) | EC2 instance type to use for the go-carbon containers | `string` | `"m5.xlarge"` | no |
| <a name="input_go_carbon_node_count"></a> [go\_carbon\_node\_count](#input\_go\_carbon\_node\_count) | Number of nodes in the go-carbon cluster | `any` | n/a | yes |
| <a name="input_go_carbon_storage_size"></a> [go\_carbon\_storage\_size](#input\_go\_carbon\_storage\_size) | Amount of EBS storage per go-carbon node | `number` | `350` | no |
| <a name="input_graphite_subnets"></a> [graphite\_subnets](#input\_graphite\_subnets) | Subnets for the graphite infrastructure | `any` | n/a | yes |
| <a name="input_graphite_web_image_tag"></a> [graphite\_web\_image\_tag](#input\_graphite\_web\_image\_tag) | The image hash/tag that will be used to run graphite-web | `string` | `"1ca8e602c15ba9ed7737976d01c9d1ba10eafa40"` | no |
| <a name="input_graphite_web_instance_type"></a> [graphite\_web\_instance\_type](#input\_graphite\_web\_instance\_type) | EC2 instance type to use for the graphite-web containers | `string` | `"c5.xlarge"` | no |
| <a name="input_graphite_web_node_count"></a> [graphite\_web\_node\_count](#input\_graphite\_web\_node\_count) | Number of nodes in the graphite-web cluster | `any` | n/a | yes |
| <a name="input_hostname_prefix"></a> [hostname\_prefix](#input\_hostname\_prefix) | Host prefix to use for ASG DNS | `string` | `"graphite"` | no |
| <a name="input_owner"></a> [owner](#input\_owner) | The email address of the owner of this account | `string` | n/a | yes |
| <a name="input_pagerduty_url"></a> [pagerduty\_url](#input\_pagerduty\_url) | A pagerduty endpoint URL to send alarms to. | `string` | n/a | yes |
| <a name="input_region"></a> [region](#input\_region) | The AWS region this service will be deployed | `string` | `"us-west-2"` | no |
| <a name="input_security_groups"></a> [security\_groups](#input\_security\_groups) | Security groups necessary for this infrastructure | `any` | n/a | yes |
| <a name="input_team_name"></a> [team\_name](#input\_team\_name) | Name of the team owning this infrastructure | `any` | n/a | yes |
| <a name="input_vpc_id"></a> [vpc\_id](#input\_vpc\_id) | The VPC to deploy this stack to | `string` | n/a | yes |
| <a name="input_vpce_allowed_principals"></a> [vpce\_allowed\_principals](#input\_vpce\_allowed\_principals) | The list of trusted accounts for the VPCe (by default we use sysinfra prod and dev grafana accounts). | `list` | <pre>[<br>  "arn:aws:iam::109561199089:root",<br>  "arn:aws:iam::963768028156:root"<br>]</pre> | no |

### Outputs

| Name | Description |
|------|-------------|
| <a name="output_carbon_c_relay_lb"></a> [carbon\_c\_relay\_lb](#output\_carbon\_c\_relay\_lb) | n/a |
| <a name="output_graphite_web_lb"></a> [graphite\_web\_lb](#output\_graphite\_web\_lb) | n/a |
| <a name="output_graphite_web_private_dns_name"></a> [graphite\_web\_private\_dns\_name](#output\_graphite\_web\_private\_dns\_name) | The private DNS name of the VPC endpoint service created. |
| <a name="output_graphite_web_vpce_service_name"></a> [graphite\_web\_vpce\_service\_name](#output\_graphite\_web\_vpce\_service\_name) | The service name of graphite-web VPC endpoint service |
| <a name="output_pagerduty_sns_topic_arn"></a> [pagerduty\_sns\_topic\_arn](#output\_pagerduty\_sns\_topic\_arn) | The SNS topic ARN created to send pagerduty alerts |
| <a name="output_zone"></a> [zone](#output\_zone) | DNS delegation information |
<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->


## Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)
  * [`shellcheck`](https://github.com/koalaman/shellcheck#user-content-installing)

Run `pre-commit install` to install `pre-commit` hook.

### Known Issues

You may encounter the following issues when `terraform validate` part of the `pre-commit` hook is executed:

* `terraform` AWS provider requires a region to be set when `terraform validate` is being performed. If a region not set related error is prompted, set `export AWS_REGION=us-west-2` in your current terminal session.
* When trying to validate modules under the `modules` folder, `terraform init` needs to be executed in each module folder for the `pre-commit` to successfully validate each individual modules.
