module "dns_delegation" {
  source  = "git@git.xarth.tv:video-coreservices/tf-mod-live-video-dns-delegation.git//primary?ref=v1.0.8"
  service = "graphite-${var.team_name}"
  domain  = "live-video.a2z.com"
}

resource "aws_route53_record" "vpce_dns_verification" {
  zone_id = module.dns_delegation.primary.zone.id
  name    = module.graphite_vpc_endpoint_service.private_dns_name_configuration.name
  type    = module.graphite_vpc_endpoint_service.private_dns_name_configuration.type
  ttl     = "1800"
  records = [module.graphite_vpc_endpoint_service.private_dns_name_configuration.value]
}
