# those permissions are needed in order for ec2 instances to attach enis and ebs volumes

data "aws_iam_policy_document" "auto_discover_cluster" {
  statement {
    effect = "Allow"

    actions = [
      "ec2:DescribeNetworkInterfaces",
      "ec2:DescribeVolumes",
      "ec2:AttachNetworkInterface",
      "ec2:AttachVolume",
      "ec2:DescribeInstances",
      "ec2:DescribeTags",
      "autoscaling:DescribeAutoScalingGroups",
    ]

    resources = ["*"]
  }
}

resource "aws_iam_policy" "auto_discover_cluster" {
  name   = "graphite-auto-discover-cluster"
  policy = data.aws_iam_policy_document.auto_discover_cluster.json
}

resource "aws_iam_role_policy_attachment" "auto_discover_cluster" {
  role       = split("/", module.core_account.container_iam_role)[1]
  policy_arn = aws_iam_policy.auto_discover_cluster.arn
}
