# ECS Module Input Variables

# ECS Cluster Settings

variable "ec2_instance_type" {
  description = "Type of EC2 instance."
  type        = string
}

variable "cluster_size" {
  description = "The min, max, and desired number of EC2 instances to run."
  type        = object({ min = number, max = number, desired = number })
}

variable "app_count" {
  description = "Number of docker containers to run."
  type        = number
}

variable "ami" {
  description = "An ECS enabled AMI that these ASG hosts should run with.  If empty, will use the most recent AMI"
  type        = string
  default     = ""
}

variable "task_network_mode" {
  description = "The network mode used in the application's task definition."
  default     = "bridge"
}

variable "security_groups" {
  description = "Comma-separated string of security groups to associate the ECS cluster with"
  type        = string
}

variable "subnets" {
  description = "subnets to associate this ECS cluster"
  type        = list(string)
}

# dnsmasq settings

variable "dns_servers" {
  description = <<EOF
ONLY set this if you are NOT using the `twitch_dns_route53_resolver` module.
DNS servers for resolving twitch.tv and justin.tv domains.
If provided, allows dnsmasq to act as a DNS forwarder.
Find yours here: https://wiki.twitch.com/display/SYS/What+DNS+servers+should+be+used
EOF

  type    = list(string)
  default = []
}

variable "use_dnsmasq" {
  description = "Whether or not to use the optional dns cache daemon (dnsmasq)"
  type        = bool
  default     = true
}

# AWS security / role settings

variable "ecs_host_iam_id" {
  description = "The IAM role to use for the ECS host's instance profile."
  type        = string
}

variable "service_iam_role" {
  description = "The ARN of the IAM role for the ECS service."
  type        = string
}

variable "ecs_task_role" {
  description = "The ARN of the ECS task role that allows the app to call other AWS services."
  type        = string
}

# General app/cluster settings

variable "app_name" {
  description = "The name of the application."
  type        = string
}

variable "cluster_name" {
  description = "The name of this ECS cluster."
  type        = string
}

variable "environment" {
  description = "Keep canary vs production resources separate with an environment name."
  type        = string
}

variable "owner_email" {
  description = "The email of the owning group, tagged in the ASG."
  type        = string
}

variable "app_port" {
  description = "The port that the application listens on for requests."
  type        = string
}

variable "container_definitions" {
  description = "The JSON document of container definitions for the containers that make up the ECS task."
  type        = string
}

variable "placement_strategy_type" {
  description = "one of: binpack, random, spread. See https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html"
  type        = string
  default     = "spread"
}

variable "placement_strategy_field" {
  description = "the field to use with the type of placement in placement_strategy_type"
  type        = string
  default     = "instanceId"
}

# ECS container agent settings

variable "task_cleanup_wait_duration" {
  description = "Time duration to wait from when an ECS task is stopped until the Docker container is removed."
  type        = string
  default     = "30m"
}

variable "task_shutdown_wait_duration" {
  description = "Time duration to wait from when an ECS task is given a SIGTERM to when it is forcefully killed."
  type        = string
  default     = "30s"
}

# Monitoring Settings

variable "alarm_sns_topics" {
  type        = list(string)
  description = "The list of ARN(s) of SNS topic(s) that Cloudwatch Alarms may send notifications to."
  default     = []
}

# Default settings - no need to override

variable "team_name" {
  description = "The name of the team owning these resources."
  type        = string
}

variable "log_retention_days" {
  description = "The number of days to retain CloudWatch logs."
  type        = number
  default     = 30
}

# LB settings

variable "target_group_ids" {
  description = "The target groups that the ECS service should join."
  type        = list(string)
  default     = []
}

variable "user_data" {}

variable "host_volume" {
  default = []
}
