
locals {
  // This is from https://wiki.twitch.com/display/PS/Unified+LDAP+VPC+Endpoint
  internal_ldap_hosts = {
    us-west-2 = "ldap.twitch.a2z.com"
  }

  internal_ldap_host = local.internal_ldap_hosts[data.aws_region.current.name]
}

variable "environment" {
  description = "Which env run of the service (staging/production/etc)"
  type        = string
}

variable "name" {
  description = "Name of the clusters these ASG hosts should take."
  type        = string
}

variable "min_size" {
  description = "Least number of hosts to have in this ASG"
  type        = number
}

variable "max_size" {
  description = "Most number of hosts to have in this ASG"
  type        = number
}

variable "desired_capacity" {
  description = "Default number of hosts to have in this ASG.  Should be >= min and <= max"
  type        = number
}

variable "team" {
  description = "The twitch team (feeds/events/etc) that wants this resource"
  type        = string
}

variable "owner" {
  description = "Owner's email (jlindamo@twitch.tv) that wants twitch to pay for this."
  type        = string
}

variable "root_volume_size" {
  description = "Size in GB of the root volume in the ASG"
  type        = number
  default     = 32
}

variable "cluster_name" {
  description = "Name of the ECS cluster hosts should belong to"
  type        = string
}

variable "custom_ldap_host" {
  description = "The LDAP server for authentication, if internal Twitch servers are inaccesible."
  type        = string
  default     = ""
}

variable "ldap_group" {
  description = "LDAP group to add to sudoers"
  type        = string
  default     = "team-api"
}

# EC2 Instance Image
variable "ami" {
  description = "An ECS enabled AMI that these ASG hosts should run with.  If empty, will use the most recent AMI"
  type        = string
  default     = ""
}

# EC2 Instance Type
variable "instance_type" {
  description = "AWS instance type of these hosts (c4.2xlarge, etc)"
  type        = string
}

variable "host_key_name" {
  description = "Can leave blank, but will be an SSH keypair name"
  type        = string
  default     = ""
}

variable "container_instance_profile_id" {
  description = "The permissions ID these hosts get. Should probably use the one created by core."
  type        = string
}

variable "security_groups" {
  description = "Comma-separated string of Twitch subnet security groups to add EC2 instances into."
  type        = string
}

variable "vpc_zone_identifier" {
  description = "Subnets that ASG adds hosts to.  Usually .account.private_subnets"
  type        = string
}

variable "ssm_agent_loggroup" {
  description = "CloudWatch log group to send SSM agent logs to."
  type        = string
}

variable "ecs_agent_loggroup" {
  description = "CloudWatch log group to send ECS agent logs to."
  type        = string
}

variable "ecs_init_loggroup" {
  description = "CloudWatch log group to send ECS init logs to."
  type        = string
}

variable "instance_attributes" {
  type        = map(string)
  description = "Custom attributes added to instances. Useful for placement_attributes."
  default     = {}
}

variable "task_cleanup_wait_duration" {
  description = "Time duration to wait from when an ECS task is stopped until the Docker container is removed."
  default     = "3h"
  type        = string
}

variable "task_shutdown_wait_duration" {
  description = "Time duration to wait from when an ECS task is given a SIGTERM to when it is forcefully killed."
  default     = "30s"
  type        = string
}

# Autoscaling configurations
variable "scale_out_increment" {
  description = "Number of instances to add during a Scale Out operation."
  type        = number
  default     = 1
}

variable "scale_out_cooldown" {
  description = "Seconds to wait between Scale Out operations."
  type        = number
  default     = 1200
}

variable "scale_out_evaluation_periods" {
  description = "Number of consecutive minutes the CPU usage has to be above the threshold to Scale Out."
  type        = number
  default     = 5
}

variable "scale_out_cpu_percent_threshold" {
  description = "Percentage of CPU usage above which the ASG should Scale Out."
  type        = number
  default     = 75
}

variable "scale_in_increment" {
  description = "Number of instances to remove during a Scale In operation, should be negative."
  type        = number
  default     = -1
}

variable "scale_in_cooldown" {
  description = "Seconds to wait between Scale In operations."
  type        = number
  default     = 900
}

variable "scale_in_evaluation_periods" {
  description = "Number of consecutive minutes the CPU usage has to be below or equal to the threshold to Scale In."
  type        = number
  default     = 15
}

variable "scale_in_cpu_percent_threshold" {
  description = "Percentage of CPU usage below or equal which the ASG should Scale In."
  type        = number
  default     = 10
}

# Monitoring Settings

variable "alarm_sns_topics" {
  type        = list(string)
  description = "The list of ARN(s) of SNS topic(s) that Cloudwatch Alarms may send notifications to."
  default     = []
}

variable "user_data" {}
