variable "vpc_id" {
  description = "The vpc id of the cluster"
  type        = string
}

variable "subnets" {
  description = "VPC subnets to be associated"
  type        = list(string)
}

variable "security_groups" {
  description = "Security groups to attach"
  type        = list(string)
}

variable "cluster_size" {
  description = "The min, max, and desired number of EC2 instances to run."
  type        = object({ min = number, max = number, desired = number })
}

variable "environment" {
  description = "A name for the environment that this go-carbon cluster serves"
  type        = string
}

variable "cluster_name" {
  description = "A name for the cluster that is served by this go-carbon"
  type        = string
}

variable "image_url" {
  description = "URL to a docker image for go-carbon"
  type        = string
}

variable "ecs_task_role_arn" {
  description = "The ARN of the ECS task role that allows the app to call other AWS services."
  type        = string
}

variable "owner_email" {
  description = "The email of the owning group, tagged in the ASG."
  type        = string
}

variable "service_iam_role" {
  description = "The ARN of the IAM role for the ECS service."
  type        = string
}

variable "container_instance_profile_id" {
  description = "The permissions ID these hosts get. Should probably use the one created by core."
  type        = string
}

variable "region" {
  description = "AWS region for this go-carbon cluster"
  type        = string
}

variable "account_id" {
  description = "AWS Account ID for this go-carbon cluster"
  type        = string
}

variable "log_retention_days" {
  description = "Number of days to retain CloudWatch Logs"
  type        = number
  default     = 30
}

variable "alarm_sns_topics" {
  type        = list(string)
  description = "The list of ARN(s) of SNS topic(s) that Cloudwatch Alarms may send notifications to."
  default     = []
}

variable "go_carbon_instance_type" {}
variable "team_name" {}
variable "go_carbon_storage_size" {}
variable "ebs_iops" {
  default     = 3000
  description = "iops limit for the ebs volumes. Anything above 3000 cost additional money."
}
