locals {
  metric_namespace = "CarbonRelayNG"
}

resource "aws_cloudwatch_metric_alarm" "cpu_utilization" {
  alarm_name          = "graphite_web_cpu_utilization"
  alarm_description   = "Alarm when graphite-web cpu utilization is > 80% for 5 minute. https://wiki.xarth.tv/display/VID/SHG+Metrics+and+Alarming#SHGMetricsandAlarming-graphite_web_cpu_utilization"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  metric_name         = "CPUUtilization"
  statistic           = "Average"
  namespace           = "AWS/ECS"
  alarm_actions       = var.alarm_sns_topics
  ok_actions          = var.alarm_sns_topics
  dimensions = {
    ClusterName = var.cluster_name
    ServiceName = module.ecs.ecs_service_name
  }

  evaluation_periods = "5"
  period             = "60"
  threshold          = "80"
  treat_missing_data = "missing"
}

resource "aws_cloudwatch_metric_alarm" "memory_utilization" {
  alarm_name          = "graphite_web_memory_utilization"
  alarm_description   = "Alarm when graphite-web memory utilization is > 80% for 5 minute. https://wiki.xarth.tv/display/VID/SHG+Metrics+and+Alarming#SHGMetricsandAlarming-graphite-web_memory_utilization"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  metric_name         = "MemoryUtilization"
  statistic           = "Average"
  namespace           = "AWS/ECS"
  alarm_actions       = var.alarm_sns_topics
  ok_actions          = var.alarm_sns_topics
  dimensions = {
    ClusterName = var.cluster_name
    ServiceName = module.ecs.ecs_service_name
  }

  evaluation_periods = "5"
  period             = "60"
  threshold          = "80"
  treat_missing_data = "missing"
}

resource "aws_cloudwatch_metric_alarm" "running_tasks" {
  alarm_name          = "graphite_web_running_tasks"
  alarm_description   = "Alarm when graphite-web has fewer than expected running tasks. https://wiki.xarth.tv/display/VID/SHG+Metrics+and+Alarming#SHGMetricsandAlarming-graphite-web_running_tasks"
  comparison_operator = "LessThanThreshold"
  // Count the number of tasks that are reporting CPU utilization.
  metric_name   = "CPUUtilization"
  statistic     = "SampleCount"
  namespace     = "AWS/ECS"
  alarm_actions = var.alarm_sns_topics
  ok_actions    = var.alarm_sns_topics
  dimensions = {
    ClusterName = var.cluster_name
    ServiceName = module.ecs.ecs_service_name
  }

  evaluation_periods = "5"
  period             = "60"
  threshold          = local.tasks_per_instance * var.cluster_size.desired
  treat_missing_data = "missing"
}
