output "graphite_web_lb" {
  value = module.graphite-web.lb_hostname
}

output "carbon_c_relay_lb" {
  value = module.carbon-c-relay.nlb_hostname
}

output "graphite_web_vpce_service_name" {
  description = "The service name of graphite-web VPC endpoint service"
  value       = module.graphite_vpc_endpoint_service.vpce_service_name
}

output "graphite_web_private_dns_name" {
  description = "The private DNS name of the VPC endpoint service created."
  value       = module.graphite_vpc_endpoint_service.vpce_service_private_dns_name
}

output "pagerduty_sns_topic_arn" {
  description = "The SNS topic ARN created to send pagerduty alerts"
  value       = aws_sns_topic.graphite_sns_topic.arn
}

output "zone" {
  description = "DNS delegation information"
  value       = module.dns_delegation.primary
}
