# Optional inputs
variable "env" {
  description = "Service environment - (prod|stage)"
  default     = "stage"
}

variable "region" {
  description = "The AWS region this service will be deployed"
  default     = "us-west-2"
}

# Legacy mappings of environment long names
locals {
  environment_map = {
    prod  = "production"
    stage = "staging"
    dev   = "development"
  }

  environment = local.environment_map[var.env]

  common_tags = {
    Owner       = "video-coreservices@twitch.tv"
    Service     = "graphite"
    Environment = var.env
    Source      = "video-coreservices/tf-io-graphite"
  }
}

# ASG ENI
variable "hostname_prefix" {
  description = "Host prefix to use for ASG DNS"
  default     = "graphite"
}
# ASG ENI

variable "graphite_subnets" {
  description = "Subnets for the graphite infrastructure"
}

variable "go_carbon_image_tag" {
  type        = string
  description = "The image hash/tag that will be used to run go_carbon"
  default     = "v0.15.6"
}

variable "graphite_web_image_tag" {
  type        = string
  description = "The image hash/tag that will be used to run graphite-web"
  default     = "1ca8e602c15ba9ed7737976d01c9d1ba10eafa40"
}

variable "carbon_c_relay_image_tag" {
  type        = string
  description = "The image hash/tag that will be used to run carbon-c-relay"
  default     = "v3.7.2"
}

variable "go_carbon_node_count" {
  description = "Number of nodes in the go-carbon cluster"
}

variable "graphite_web_node_count" {
  description = "Number of nodes in the graphite-web cluster"
}

variable "carbon_c_relay_node_count" {
  description = "Number of nodes in the carbon-c-relay cluster"
}

variable "pagerduty_url" {
  type        = string
  description = "A pagerduty endpoint URL to send alarms to."
}

variable "vpc_id" {
  type        = string
  description = "The VPC to deploy this stack to"
}

variable "go_carbon_instance_type" {
  description = "EC2 instance type to use for the go-carbon containers"
  default     = "m5.xlarge"
}
variable "go_carbon_storage_size" {
  description = "Amount of EBS storage per go-carbon node"
  default     = 350
}

variable "graphite_web_instance_type" {
  description = "EC2 instance type to use for the graphite-web containers"
  default     = "c5.xlarge"
}

variable "carbon_c_relay_instance_type" {
  description = "EC2 instance type to use for the carbon-c-relay containers"
  default     = "c5.xlarge"
}

variable "team_name" {
  description = "Name of the team owning this infrastructure"
}

variable "security_groups" {
  description = "Security groups necessary for this infrastructure"
}

variable "ebs_iops" {
  default     = 3000
  description = "iops limit for the ebs volumes. Anything above 3000 cost additional money."
}

variable "owner" {
  type        = string
  description = "The email address of the owner of this account"
}

locals {
  account    = var.team_name
  account_id = data.aws_caller_identity.current.account_id

  tags = {
    Owner       = var.owner
    Environment = var.env
    Service     = "${var.team_name}-graphite"
  }
}

variable "vpce_allowed_principals" {
  description = "The list of trusted accounts for the VPCe (by default we use sysinfra prod and dev grafana accounts)."
  default     = ["arn:aws:iam::109561199089:root", "arn:aws:iam::963768028156:root"] # 109561199089 - sysinfra prod, 963768028156 - sysinfra dev
}
