module "graphite_vpc_endpoint_service" {
  source             = "git@git.xarth.tv:video-coreservices/tf-mod-vpce-service.git?ref=v1.2.1"
  service_id         = "${var.team_name}-graphite-${var.env}"
  region             = var.region
  nlb_arn            = aws_lb.graphite_vpce_nlb.arn
  nlb_tg_arn         = aws_lb_target_group.graphite_vpce_nlb_tg.arn
  alb_arn            = module.graphite-web.lb_arn
  alb_listener_port  = 80
  allowed_principals = var.vpce_allowed_principals
  private_dns_name   = module.dns_delegation.primary.zone.name
}

# NLB for the VPCe.
resource "aws_lb" "graphite_vpce_nlb" {
  name               = "graphite-vpce-nlb"
  internal           = true
  load_balancer_type = "network"
  subnets            = var.graphite_subnets
  idle_timeout       = 300
}

# HTTP listener for the NLB.
resource "aws_lb_listener" "graphite_vpce_nlb_listener" {
  load_balancer_arn = aws_lb.graphite_vpce_nlb.id
  port              = 80
  protocol          = "TCP"

  default_action {
    target_group_arn = aws_lb_target_group.graphite_vpce_nlb_tg.id
    type             = "forward"
  }
}

# Target group that'll get updated by the lambda created by the module.
resource "aws_lb_target_group" "graphite_vpce_nlb_tg" {
  name        = "graphite-vpce-nlb-tg"
  port        = 80
  protocol    = "TCP"
  vpc_id      = var.vpc_id
  target_type = "ip"
}
