# tf-mod-icp
a Terraform module managing ACM Private CA instances and service leaf certificates.

## usage
```
module "icp" {
  source = "git::git+ssh://git@git.xarth.tv/video-coreservices/tf-mod-icp"
  account = var.account
  region = var.region
  owner = var.owner
  service-acct-icp-leaf-role = var.service-acct-icp-leaf-role
  service-name = var.service-name
  service-endpoint = var.service-endpoint
}
```

This will produce:
 - a Root PCA instance
 - an Intermediate PCA instance
 - a leaf key, stored in Secrets Manager
 - a leaf CSR, passed to the intermediate PCA instance,
 - and a service leaf certificate signed by the intermediate PCA instance.

The following roles are also created:
 - root-maintenance: (restricted access) used to perform maintenance on the root PCA instance.
 - intermediate-maintenance: (restricted access) used to perform maintenance on the intermediate PCA instance.
 - service-leaf-issuance: (restricted access) used to issue service leaf certificates.
 - service-intermediate: (org-assumable) used to obtain root/intermediate CA bundle.
 - service-leaf: (restricted to *service-acct-icp-leaf-role*) used to obtain service leaf certificate and key.

## WARNING
This module uses the Terraform *tls_private_key* resource to generate the private key for the leaf certificate request. This is intended to let users quickly set up environments to test against but SHOULD NOT BE USED FOR PRODUCTION. The private key will be stored unencrypted in your terraform state.

A secure method of key generation will be added before service launch.

## parameters
tf-mod-icp is designed with sensible defaults for most parameters.

### required
*service-acct-icp-leaf-role:*
The ARN of the role in your service's account calling ICP to fetch service leaf certificates.

*region:*
The region you're building this PCA instance in

*account:*
The human readable account name (used for tagging)

*owner:*
The human readable account owner (used for tagging)

*service-name:*
A single-word service name, used for resoure naming.

*service-endpoint:*
The dns name of your service endpoint, used as certificate CN

*root-ca-generation:*
The version of root CA certificate (starts at 1, the default)

*intermediate-ca-generation:*
The version of intermediate CA certificate (starts at 1, the default)

### additional parameters
These should be left at the default in most cases.

*video_organization_id:*
AWS Organizations ID for the Video org.

*ca-key-algo:*
The key algorithm for PCA instance certificates

*csr-key-algo:*
The key algorithm for leaf certificate requests

*csr-key-curve:*
The ecdsa curve for ECDSA certificate requests

*csr-key-bits:*
The key size for RSA certificate requests

*signing-algo:*
The signing algorithm for certificates

*root-ca-validity:*
Length of root ca validity in years

*intermediate-ca-validity:*
Length of intermediate ca validity in years

*leaf-validity:*
Length of leaf certificate validity in years

*crl-expiration:*
CRL expiration time in days

