data "aws_iam_policy_document" "root-maintenance-assume" {
  statement {
    effect = "Allow"
    principals {
      identifiers = ["arn:aws:iam::727820809195:root"]
      type        = "AWS"
    }
    actions = ["sts:AssumeRole"]
    condition {
      test     = "StringEquals"
      variable = "sts:ExternalId"
      values   = [ var.root-maintenance-assume-isengardid ]
    }
  }
}

data "aws_iam_policy_document" "intermediate-maintenance-assume" {
  statement {
    effect = "Allow"
    principals {
      identifiers = ["arn:aws:iam::727820809195:root"]
      type        = "AWS"
    }
    actions = ["sts:AssumeRole"]
    condition {
      test     = "StringEquals"
      variable = "sts:ExternalId"
      values   = [ var.intermediate-maintenance-assume-isengardid ]
    }
  }
}

data "aws_iam_policy_document" "service-leaf-issuance-assume" {
  statement {
    effect = "Allow"
    principals {
      identifiers = ["arn:aws:iam::727820809195:root"]
      type        = "AWS"
    }
    actions = ["sts:AssumeRole"]
    condition {
      test     = "StringEquals"
      variable = "sts:ExternalId"
      values   = [ var.service-leaf-issuance-assume-isengardid ]
    }
  }
}

