resource "aws_acmpca_certificate" "leaf" {
  certificate_authority_arn   = aws_acmpca_certificate_authority.intermediate.arn
  certificate_signing_request = tls_cert_request.csr.cert_request_pem
  signing_algorithm           = var.signing-algo
  validity {
    type  = "YEARS"
    value = var.leaf-validity
  }
}

resource "tls_private_key" "key" {
  algorithm   = var.csr-key-algo
  ecdsa_curve = var.csr-key-curve
}

resource "tls_cert_request" "csr" {
  key_algorithm   = var.csr-key-algo
  private_key_pem = tls_private_key.key.private_key_pem

  subject {
    common_name = var.service-endpoint
  }
}

