resource "aws_iam_role" "root-maintenance" {
  name                 = "icp-root-maintenance"
  assume_role_policy   = data.aws_iam_policy_document.root-maintenance-assume.json
  max_session_duration = 43200
}

resource "aws_iam_role_policy_attachment" "root-maintenance" {
  role       = aws_iam_role.root-maintenance.name
  policy_arn = aws_iam_policy.root-maintenance.arn
}


resource "aws_iam_role" "intermediate-maintenance" {
  name                 = "icp-intermediate-maintenance"
  assume_role_policy   = data.aws_iam_policy_document.intermediate-maintenance-assume.json
  max_session_duration = 43200
}

resource "aws_iam_role_policy_attachment" "intermediate-maintenance" {
  role       = aws_iam_role.intermediate-maintenance.name
  policy_arn = aws_iam_policy.intermediate-maintenance.arn
}


resource "aws_iam_role" "service-leaf-issuance" {
  name                 = "icp-service-leaf-issuance"
  assume_role_policy   = data.aws_iam_policy_document.service-leaf-issuance-assume.json
  max_session_duration = 43200
}

resource "aws_iam_role_policy_attachment" "service-leaf-issuance" {
  role       = aws_iam_role.service-leaf-issuance.name
  policy_arn = aws_iam_policy.service-leaf-issuance.arn
}


resource "aws_iam_role" "service-intermediate" {
  name               = "icp-service-intermediate"
  assume_role_policy = aws_iam_policy.organization_principal.policy
}

resource "aws_iam_role_policy_attachment" "service-intermediate" {
  role       = aws_iam_role.service-intermediate.name
  policy_arn = aws_iam_policy.service-intermediate.arn
}


resource "aws_iam_role" "service-leaf" {
  name               = "icp-service-leaf"
  assume_role_policy = aws_iam_policy.service-leaf-assume.policy
}

resource "aws_iam_role_policy_attachment" "service-leaf" {
  role       = aws_iam_role.service-leaf.name
  policy_arn = aws_iam_policy.service-leaf.arn
}


