resource "random_id" "id" {
	  byte_length = 8
}

resource "aws_secretsmanager_secret" "leaf_csr" {
  name = "${var.service-name}-csr-${random_id.id.hex}"
}

resource "aws_secretsmanager_secret_version" "leaf_csr" {
  secret_id     = aws_secretsmanager_secret.leaf_csr.id
  secret_string = tls_cert_request.csr.cert_request_pem
}

resource "aws_secretsmanager_secret" "leaf_key" {
  name = "${var.service-name}-key-${random_id.id.hex}"
}

resource "aws_secretsmanager_secret_version" "leaf_key" {
  secret_id     = aws_secretsmanager_secret.leaf_key.id
  secret_string = tls_private_key.key.private_key_pem
}

